﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <mutex>

#include <nn/nn_Macro.h>
#include <nn/util/util_TypedStorage.h>
#include <nn/os/os_Types.h>
#include <nn/os/os_SystemEventTypes.h>

#include "os_Common.h"
#include "os_InterProcessEventImpl.h"
#include "os_MultipleWaitHelper.h"
#include "os_MultipleWaitHolderOfInterProcessEvent.h"

//---------------------------------------------------------------------------
//  C++ 関数の定義
//---------------------------------------------------------------------------

namespace nn { namespace os {
namespace detail {

//--------------------------------------------------------------------------
// InterProcessEventType オブジェクトの状態をポーリング
TriBool MultiWaitHolderOfInterProcessEvent::IsSignaled() const NN_NOEXCEPT
{
    return TriBool::Indeterminate;
}

// Wait 操作に使うハンドルを返す
bool MultiWaitHolderOfInterProcessEvent::GetNativeHandle(NativeHandle* pOut) const NN_NOEXCEPT
{
    *pOut = m_InterProcessEvent->_readableHandle;
    return true;
}


}   // namespace detail
}}  // namespace nn::os

