﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Windows.h>
#include <nn/nn_Macro.h>
#include <nn/nn_TimeSpan.h>
#include <nn/os/os_NativeHandleTypes.h>

#include "os_MultipleWaitHelper.h"
#include "os_TimeoutHelper.h"

//--------------------------------------------------------------------------

namespace nn { namespace os {
namespace detail {

//--------------------------------------------------------------------------
//  MultiWaitImplByWin32 クラス
//

class   MultiWaitImplByWin32
{
public:
    // この数は Horizon 環境の (nn::svc::ArgumentHandleCountMax + 1) に等しい。
    static const int NativeHandleArrayCountMax = 33;

private:
    int  WaitForAnyObjects(int num, NativeHandle array[], int arraySize, DWORD dwMilliSeconds) NN_NOEXCEPT;

public:
    // コンストラクタ と デストラクタ
    MultiWaitImplByWin32()  NN_NOEXCEPT;
    ~MultiWaitImplByWin32() NN_NOEXCEPT;

    // メンバ関数
    void CancelWait() NN_NOEXCEPT;
    int WaitAny(NativeHandle array[], int arraySize, int num) NN_NOEXCEPT
    {
        return WaitForAnyObjects( num, array, arraySize, INFINITE );
    }

    int  TryWaitAny(NativeHandle array[], int arraySize, int num) NN_NOEXCEPT
    {
        return WaitForAnyObjects( num, array, arraySize, 0 );
    }

    int  TimedWaitAny(NativeHandle array[], int arraySize, int num, TimeSpan timeSpan) NN_NOEXCEPT;

    void SetCurrentThreadHandleForCancelWait() NN_NOEXCEPT
    {
    }

    void ClearCurrentThreadHandleForCancelWait() NN_NOEXCEPT
    {
    }

private:
    HANDLE      m_WakeupEvent;      // スレッド起床用のイベント
};

typedef MultiWaitImplByWin32  MultiWaitImplByTarget;

}   // namespace detail
}}  // namespace nn::os

