﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <stdint.h>

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>
#include <nn/result/result_HandlingUtility.h>

#include "os_Diag.h"
#include "os_Common.h"
#include "os_MultipleWaitHelper.h"
#include "os_MultipleWaitHolderBase.h"

#include <nn/svc/svc_Base.h>
#include <nn/svc/svc_Dd.h>
#include <nn/svc/svc_HardwareParamsSelect.h>
#include <nn/svc/svc_Synchronization.h>
#include <nn/svc/svc_Result.h>


namespace nn { namespace os {
namespace detail {

//--------------------------------------------------------------------------

int MultiWaitImplByHorizon::WaitSynchronizationN(int num, NativeHandle array[], int arraySize, int64_t nanoSeconds) NN_NOEXCEPT
{
    NN_UNUSED(arraySize);
    NN_SDK_ASSERT(!(num == 0 && nanoSeconds == 0));

    int32_t index;
    auto result = nn::svc::WaitSynchronization(&index, reinterpret_cast<const nn::svc::Handle*>(array), num, nanoSeconds);

    // 返値の確認
    NN_RESULT_TRY(result)
        NN_RESULT_CATCH( svc::ResultTimeout )
        {
            return MultiWaitImpl::WaitIsTimedout;
        }
        NN_RESULT_CATCH( svc::ResultCancelled )
        {
            return MultiWaitImpl::WaitIsCanceled;
        }
        NN_RESULT_CATCH_ALL
        {
            NN_ABORT_UNLESS_RESULT_SUCCESS(result);
        }
    NN_RESULT_END_TRY

    return index;
}

//--------------------------------------------------------------------------
// クリア
void MultiWaitImplByHorizon::CancelWait() NN_NOEXCEPT
{
    auto result = nn::svc::CancelSynchronization( m_Handle );
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
}


}   // namespace detail
}}  // namespace nn::os

