﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_TimeSpan.h>

#include <nn/os/os_NativeHandleTypes.h>
#include <nn/os/os_EventCommon.h>
#include <nn/os/os_InterruptEventCommon.h>
#include <nn/svc/svc_Types.h>
#include <nn/svc/svc_Handle.h>

#include "os_Common.h"

namespace nn { namespace os {
namespace detail {

//--------------------------------------------------------------------------
//  InterruptEventImplByHorizon クラス
//

class   InterruptEventImplByHorizon
{
public:
    explicit InterruptEventImplByHorizon(InterruptName name, EventClearMode clearMode) NN_NOEXCEPT;
    ~InterruptEventImplByHorizon()      NN_NOEXCEPT;

    void Clear()                        NN_NOEXCEPT;
    void Wait()                         NN_NOEXCEPT;
    bool TryWait()                      NN_NOEXCEPT;
    bool TimedWait(TimeSpan timeSpan)   NN_NOEXCEPT;

    TriBool IsSignaled() NN_NOEXCEPT
    {
        return TriBool::Indeterminate;
    }

    NativeHandle GetHandle() const NN_NOEXCEPT
    {
        return NativeHandle( static_cast<nnHandle>(m_Handle).value );
    }

private:
    nn::svc::Handle     m_Handle;
    bool                m_ManualReset;
};

typedef InterruptEventImplByHorizon     InterruptEventImplByTarget;


}   // namespace detail
}}  // namespace nn::os

