﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_Config.h>

#if !defined(NN_BUILD_CONFIG_OS_SUPPORTS_WIN32)
    #error  "OS 種別として Win32 が指定されていません。"
#endif

#include <nn/nn_Windows.h>
#include <nn/nn_Common.h>
#include <nn/os/detail/os_InternalCriticalSection.h>

//--------------------------------------------------------------------------

namespace nn { namespace os {
namespace detail {

struct  CriticalSectionWin32
{
    CRITICAL_SECTION    criticalSection;
};

static_assert( NN_ALIGNOF(InternalCriticalSectionStorage) >= NN_ALIGNOF(CriticalSectionWin32), "");
static_assert( sizeof(CriticalSectionWin32) == 8 + sizeof(void*) * 4, "");

}   // namespace detail
}}  // namespace nn::os

