﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_Config.h>

#if !defined(NN_BUILD_CONFIG_OS_SUPPORTS_WIN32)
    #error  "OS 種別として Win32 が指定されていません。"
#endif

#include <condition_variable>
#include <nn/nn_Windows.h>
#include <nn/nn_Common.h>
#include <nn/os/detail/os_InternalConditionVariable.h>

//--------------------------------------------------------------------------
//  Win32 用の InternalConditionVariable クラスの実装において、
//  std::condition_variable_any クラスを利用する場合に定義するマクロ。
//  これを未定義にした場合は、::CONDITION_VARIABLE を利用する実装になる。
//
//  このマクロの定義／未定義を変更する場合は、以下も同時に修正が必要。
//  - Programs/Chris/Include/nn/os/detail/os_ConditionVariableApi-os.win32.h
//  - Programs/Chris/Include/nnc/os/detail/os_ConditionVariableApi-os.win32.h
//
#undef  NN_OS_USE_STD_CONDITION_VARIABLE_CLASS


//--------------------------------------------------------------------------

namespace nn { namespace os {
namespace detail {

struct  ConditionVariableWin32
{
#if defined(NN_OS_USE_STD_CONDITION_VARIABLE_CLASS)
    std::condition_variable_any conditionVariable;
#else
    CONDITION_VARIABLE  conditionVariable;
    void*               _padding;
#endif
};

static_assert( NN_ALIGNOF(InternalConditionVariableStorage) >= NN_ALIGNOF(ConditionVariableWin32), "");
static_assert( sizeof(ConditionVariableWin32) == sizeof(void*) * 2, "");

}   // namespace detail
}}  // namespace nn::os

