﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Windows.h>
#include <nn/nn_Macro.h>
#include <nn/nn_TimeSpan.h>
#include <nn/os/os_NativeHandleTypes.h>
#include <nn/os/os_Result.h>
#include <nn/os/os_EventCommon.h>

#include "os_Common.h"

//--------------------------------------------------------------------------

namespace nn { namespace os {
namespace detail {

//--------------------------------------------------------------------------
//  InterProcessEventImplByWin32 クラス
//

class   InterProcessEventImplByWin32
{
public:
    // メンバ関数
    static Result Create(NativeHandle*, NativeHandle*) NN_NOEXCEPT;
    static void   Close(NativeHandle) NN_NOEXCEPT;
    static void   Signal(NativeHandle) NN_NOEXCEPT;
    static void   Clear(NativeHandle) NN_NOEXCEPT;
    static void   Wait(NativeHandle, bool autoClear) NN_NOEXCEPT;
    static bool   TryWait(NativeHandle, bool autoClear) NN_NOEXCEPT;
    static bool   TimedWait(NativeHandle, bool autoClear, TimeSpan) NN_NOEXCEPT;

private:
    static bool   ResetEventSignal(NativeHandle handle) NN_NOEXCEPT;
};

typedef InterProcessEventImplByWin32   InterProcessEventImpl;

}   // namespace detail
}}  // namespace nn::os

