﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "os_Common.h"

#include <new>
#include <nn/nn_Macro.h>
#include <nn/init/init_Startup.h>
#include <nn/os/os_Config.h>
#include <nn/os/os_UserExceptionHandler.h>
#include <nn/os/os_DefaultUserExceptionHandler.h>

#include "os_OsResourceManager.h"

namespace nn { namespace os {
    void InitializeVirtualAddressMemory() NN_NOEXCEPT;
}}

//--------------------------------------------------------------------------
//  OS-API ライブラリの初期化を行ないます。
//
extern "C" void nnosInitialize()
{
#if 1
    // TORIAEZU: Win32 環境用のスタートアップが出来るまでの暫定対応
    //
    // このファイル自身がどこからも参照されていないと OS の初期化が出来ない
    // 現状では、os_ThreadManager-os.win32.cpp と os_TlsManager-os.win32.cpp
    // から NN_OS_DETAIL_ATTACH_EARLY_INITIALIZER() することで、
    // OS 関連機能を使用する場合はリンクされるようにしている。
    static bool calledOnce = false;
    if (calledOnce)
    {
        return;
    }
    calledOnce = true;
#endif

    // OS 関連リソースの初期化（コンストラクタ呼び出し）
    new( nn::os::detail::GetOsResourceManagerStorage() ) nn::os::detail::OsResourceManager;

    // デフォルトユーザー例外ハンドラを登録
    nn::os::SetUserExceptionHandler(nn::os::DefaultUserExceptionHandler, nn::os::HandlerStackUsesThreadStack, 0, nn::os::UserExceptionInfoUsesThreadStack);

    // nnosInitialize の後、nninitStartup の前に呼ぶ
    nn::os::InitializeVirtualAddressMemory();

    // スタートアップ初期化ルーチンの呼出し（必ず最後に呼ぶ）
    nninitStartup();
}

