﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/os/os_Config.h>
#include <nn/os/os_Argument.h>

#include "os_Common.h"

//--------------------------------------------------------------------------
//  cos 用の main 関数です。
//  argc/argv 引数を保存して nnMain() を呼出します。
//

namespace nn { namespace os {

void SetHostArgc(int    argc) NN_NOEXCEPT;
void SetHostArgv(char** argv) NN_NOEXCEPT;

}}  // namespace nn::os

extern "C" void nnMain();

int main(int argc, char** argv)
{
    nn::os::SetHostArgc(argc);
    nn::os::SetHostArgv(argv);

    nnMain();

    return 0;
}
