﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_Config.h>

#include <nn/nn_Windows.h>
#include <nn/nn_Common.h>
#include <nn/os/os_ThreadTypes.h>
#include <nn/os/os_FiberTypes.h>


namespace nn { namespace os { namespace detail {

inline FiberType* CallFiberFunction(FiberFunction function, void *argument) NN_NOEXCEPT
{
    return function(argument);
}

//--------------------------------------------------------------------------

class FiberImplByWin32
{
public:
    static void Initialize(FiberType* fiber, void (*entryPoint)(FiberType*)) NN_NOEXCEPT;
    static void Finalize(FiberType* fiber) NN_NOEXCEPT;
    static void ConvertThreadToFiber(FiberType* fiber) NN_NOEXCEPT;
    static void ConvertFiberToThread(FiberType* fiber) NN_NOEXCEPT;
    static void Switch(FiberType* currentFiber, FiberType* fiber) NN_NOEXCEPT;

    static bool MapAliasStack(const void* to, const void* from, size_t size) NN_NOEXCEPT
    {
        NN_UNUSED(to);
        NN_UNUSED(from);
        NN_UNUSED(size);
        return true;
    }

    static bool UnmapAliasStack(const void* to, const void* from, size_t size) NN_NOEXCEPT
    {
        NN_UNUSED(to);
        NN_UNUSED(from);
        NN_UNUSED(size);
        return true;
    }
};

typedef FiberImplByWin32 FiberImpl;

inline FiberType* CallFiberFunction(FiberFunction function, void *argument) NN_NOEXCEPT;


//--------------------------------------------------------------------------

}}} // namespace nn::os::detail

