﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "os_Common.h"

#include <nn/os/os_Config.h>

#include <mutex>
#include <nn/nn_Windows.h>

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/os/os_FiberTypes.h>

#include "os_Diag.h"
#include "os_FiberImpl-os.win32.h"


namespace nn { namespace os { namespace detail {

//-----------------------------------------------------------------------------

void FiberImplByWin32::Initialize(FiberType* fiber, void (*entryPoint)(FiberType*)) NN_NOEXCEPT
{
    void* win32fiber = ::CreateFiber( fiber->_stackSize, reinterpret_cast<LPFIBER_START_ROUTINE>(entryPoint), fiber );
    NN_SDK_ASSERT( win32fiber != NULL );

    fiber->_impl._win32fiber = win32fiber;
}

void FiberImplByWin32::Finalize(FiberType* fiber) NN_NOEXCEPT
{
    ::DeleteFiber( fiber->_impl._win32fiber );

    fiber->_impl._win32fiber = NULL;
}

void FiberImplByWin32::ConvertThreadToFiber(FiberType* fiber) NN_NOEXCEPT
{
    void* win32fiber = ::ConvertThreadToFiber( 0 );
    NN_SDK_ASSERT( win32fiber != NULL );

    fiber->_impl._win32fiber = win32fiber;
}

void FiberImplByWin32::ConvertFiberToThread(FiberType* fiber) NN_NOEXCEPT
{
    BOOL ret = ::ConvertFiberToThread();
    NN_SDK_ASSERT( ret != 0 );
    NN_UNUSED(ret);

    fiber->_impl._win32fiber = NULL;
}

void FiberImplByWin32::Switch(FiberType* currentFiber, FiberType* nextFiber) NN_NOEXCEPT
{
    NN_UNUSED(currentFiber);
    ::SwitchToFiber( nextFiber->_impl._win32fiber );
}

//-----------------------------------------------------------------------------

}}} // namespace nn::os::detail

