﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os/os_Config.h>
#include <nn/diag/text/diag_SdkTextOs.h>

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/os/os_FiberTypes.h>

#include "os_Diag.h"
#include "os_Common.h"
#include "os_FiberImpl-os.horizon.h"
#include "os_FiberContextDispatcher-os.horizon.h"

#include <nn/svc/svc_Base.h>
#include <nn/svc/svc_Result.h>


namespace nn { namespace os { namespace detail {

static_assert(sizeof(FiberContextForHorizon) == NN_OS_SIZEOF_FIBER_CONTEXT, "");

//-----------------------------------------------------------------------------
//  ファイバオブジェクトの初期化
//
void FiberImplByHorizon::Initialize(FiberType* fiber, void (*entryPoint)(FiberType*)) NN_NOEXCEPT
{
    uintptr_t stackTop    = reinterpret_cast<uintptr_t>( fiber->_stack );
    uintptr_t stackBottom = stackTop + fiber->_stackSize;
    auto*     context     = reinterpret_cast<FiberContextForHorizon*>( stackBottom - sizeof(FiberContextForHorizon) );

    NN_SDK_ASSERT( fiber->_stack <= context,
        NN_TEXT_OS("nn::os::InitializeFiber(): ファイバのスタックサイズが小さすぎます（size=%zu）"), fiber->_stackSize);

#if defined(NN_BUILD_CONFIG_CPU_ARM64)
    context->reg_x0  = reinterpret_cast<Bit64>(fiber);
    context->reg_x30 = reinterpret_cast<Bit64>(entryPoint);
    fiber->_impl._sp = context;
#elif defined(NN_BUILD_CONFIG_CPU_ARM)
    context->reg_r0  = reinterpret_cast<Bit32>(fiber);
    context->reg_lr  = reinterpret_cast<Bit32>(entryPoint);
    fiber->_impl._sp = context;
#endif
}

//-----------------------------------------------------------------------------
//  ファイバスタックのエイリアスマップ構築
//
bool FiberImplByHorizon::MapAliasStack(const void* to, const void* from, size_t size) NN_NOEXCEPT
{
    // SVC を発行して、スタックのエイリアスを構築する
    Result ret = svc::MapMemory( reinterpret_cast<uintptr_t>(to),
                                 reinterpret_cast<uintptr_t>(from),
                                 size);

    return ret.IsSuccess() ? true : false;
}

//-----------------------------------------------------------------------------
//  ファイバスタックのエイリアスマップ解除
//
bool FiberImplByHorizon::UnmapAliasStack(const void* to, const void* from, size_t size) NN_NOEXCEPT
{
    // SVC を発行して、スタックのエイリアスを解除する
    Result ret = svc::UnmapMemory( reinterpret_cast<uintptr_t>(to),
                                   reinterpret_cast<uintptr_t>(from),
                                   size);

    return ret.IsSuccess() ? true : false;
}

//-----------------------------------------------------------------------------

}}} // namespace nn::os::detail

