﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_Config.h>

#include <nn/nn_SdkAssert.h>
#include <nn/nn_Abort.h>
#include <nn/nn_Macro.h>


namespace nn { namespace os {
namespace detail {

NN_NORETURN void NotImplemented(const char* functionName, int line) NN_NOEXCEPT;

//--------------------------------------------------------------------------
//  OS ライブラリ内で未実装を宣言し、実行を停止します。
//
//  OS ライブラリ内で実行を停止し、Abort します。
//  実行停止前には、OS ライブラリ関数が未実装であることを
//  示すメッセージがログ出力されます。
//
#if defined(NN_DETAIL_ENABLE_ABORT_MESSAGE)
    #define NN_OS_NOT_IMPLEMENTED() detail::NotImplemented(__FUNCTION__, __LINE__)
#else
    #define NN_OS_NOT_IMPLEMENTED() detail::NotImplemented("", 0)
#endif



}   // namespace detail
}}  // namespace nn::os

