﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_Config.h>
#include <nn/nn_Macro.h>

#include "os_OsResourceManager.h"
#include "os_AslrSpaceManagerTypes.h"


namespace nn { namespace os {
namespace detail {

//---------------------------------------------------------------------------
// AslrSpaceManager のインスタンスを取得する
inline AslrSpaceManager* GetAslrSpaceManagerInstance() NN_NOEXCEPT
{
    return &GetOsResourceManagerStorage()->aslrSpaceManager;
}

//--------------------------------------------------------------------------

}   // namespace detail
}}  // namespace nn::os

