﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using nn;
using nn.sf;
using std;

namespace nn.ncm
{
    [CppRefPath(@"<nn/ncm/ncm_DataId.h>")]
    [ExternalStruct(8, 8)]
    public struct DataId
    {
    }

    [CppRefPath(@"<nn/ncm/ncm_ProgramId.h>")]
    [ExternalStruct(8, 8)]
    public struct ProgramId
    {
    }

    [CppRefPath(@"<nn/ncm/ncm_StorageId.h>")]
    [ExternalStruct(1, 4)]
    public struct StorageId
    {
    }
}

namespace nn.lr
{
    [CppRefPath(@"<nn/lr/lr_LocationResolver.h>")]
    [ExternalStruct(768, 4)]
    [LargeData]
    [Pre(@"::nn::lr::IsValid(_)")]
    public struct Path
    {
    }

    [CppRefPath(@"<nn/lr/lr_ILocationResolver.h>")]
    public interface ILocationResolver : IServiceObject
    {
        [MethodId(0)]
        Result ResolveProgramPath(Out<Path> outValue, nn.ncm.ProgramId id);

        [MethodId(1)]
        Result RedirectProgramPath(nn.ncm.ProgramId id, Path redirectedPath);

        [MethodId(2)]
        Result ResolveApplicationControlPath(Out<Path> outValue, nn.ncm.ProgramId id);

        [MethodId(3)]
        Result ResolveApplicationHtmlDocumentPath(Out<Path> outValue, nn.ncm.ProgramId id);

        [MethodId(4)]
        Result ResolveDataPath(Out<Path> outValue, nn.ncm.DataId id);

        [MethodId(5)]
        Result RedirectApplicationControlPath(nn.ncm.ProgramId id, Path redirectedPath);

        [MethodId(6)]
        Result RedirectApplicationHtmlDocumentPath(nn.ncm.ProgramId id, Path redirectedPath);

        [MethodId(7)]
        Result ResolveApplicationLegalInformationPath(Out<Path> outValue, nn.ncm.ProgramId id);

        [MethodId(8)]
        Result RedirectApplicationLegalInformationPath(nn.ncm.ProgramId id, Path redirectedPath);

        [MethodId(9)]
        Result Refresh();

        [MethodId(10)]
        Result RedirectApplicationProgramPath(nn.ncm.ProgramId id, Path redirectedPath);

        [MethodId(11)]
        Result ClearApplicationRedirection();

        [MethodId(12)]
        Result EraseProgramRedirection(nn.ncm.ProgramId programId);

        [MethodId(13)]
        Result EraseApplicationControlRedirection(nn.ncm.ProgramId programId);

        [MethodId(14)]
        Result EraseApplicationHtmlDocumentRedirection(nn.ncm.ProgramId programId);

        [MethodId(15)]
        Result EraseApplicationLegalInformationRedirection(nn.ncm.ProgramId programId);
    }

    [CppRefPath(@"<nn/lr/lr_ILocationResolverManager.h>")]
    public struct ResolverName
    {
        [FixedArray(16)]
        public char_t[] str;
    }

    [CppRefPath(@"<nn/lr/lr_ILocationResolverManager.h>")]
    public interface ILocationResolverManager : IServiceObject
    {
        [MethodId(0)]
        Result OpenLocationResolver(Out<ILocationResolver> outValue, nn.Bit8 storageId);

        [MethodId(1)]
        Result OpenRegisteredLocationResolver(Out<IRegisteredLocationResolver> outValue);

        [MethodId(2)]
        Result RefreshLocationResolver(nn.Bit8 storageId);

        [MethodId(3)]
        Result OpenAddOnContentLocationResolver(Out<IAddOnContentLocationResolver> outValue);
    }

    [CppRefPath(@"<nn/lr/lr_IRegisteredLocationResolver.h>")]
    public interface IRegisteredLocationResolver : IServiceObject
    {
        [MethodId(0)]
        Result ResolveProgramPath(Out<Path> outValue, nn.ncm.ProgramId id);

        [MethodId(1)]
        Result RegisterProgramPath(nn.ncm.ProgramId id, Path patchPath);

        [MethodId(2)]
        Result UnregisterProgramPath(nn.ncm.ProgramId id);

        [MethodId(3)]
        Result RedirectProgramPath(nn.ncm.ProgramId id, Path patchPath);

        [MethodId(4)]
        Result ResolveHtmlDocumentPath(Out<Path> outValue, nn.ncm.ProgramId id);

        [MethodId(5)]
        Result RegisterHtmlDocumentPath(nn.ncm.ProgramId id, Path patchPath);

        [MethodId(6)]
        Result UnregisterHtmlDocumentPath(nn.ncm.ProgramId id);

        [MethodId(7)]
        Result RedirectHtmlDocumentPath(nn.ncm.ProgramId id, Path patchPath);
    }

    [CppRefPath(@"<nn/lr/lr_IAddOnContentLocationResolver.h>")]
    public interface IAddOnContentLocationResolver : IServiceObject
    {
        [MethodId(0)]
        Result ResolveAddOnContentPath(Out<Path> outValue, nn.ncm.DataId id);

        [MethodId(1)]
        Result RegisterAddOnContentStorage(nn.ncm.DataId id, nn.ncm.StorageId storageId);

        [MethodId(2)]
        Result UnregisterAllAddOnContentPath();
    }
}
