﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/sf/sf_HipcClient.h>
#include <nn/sf/sf_StdAllocationPolicy.h>
#include <nn/sf/sf_ExpHeapAllocator.h>
#include <nn/sf/sf_ObjectFactory.h>
#include <new>

#include <nn/lr/lr_ServiceName.h>
#include <nn/lr/lr_LocationResolverManagerFactory.h>
#include <nn/lr/lr_LocationResolverManagerImpl.h>

namespace nn { namespace lr {

    namespace {
        typedef sf::ObjectFactory<nn::sf::StdAllocationPolicy<std::allocator>> LocationResolverManagerFactory;
        struct AllocatorTag
        {
        };

        typedef nn::sf::ExpHeapStaticAllocator<1024, AllocatorTag> MyAllocator;

        class MyAllocatorInitializer
        {
        public:
            MyAllocatorInitializer() NN_NOEXCEPT
            {
                MyAllocator::Initialize(nn::lmem::CreationOption_NoOption);
            }
        } g_MyAllocatorInitializer;
    }

    sf::SharedPointer<ILocationResolverManager> GetLocationResolverManagerService() NN_NOEXCEPT
    {
        // TODO: 適切な分岐
#if defined( NN_BUILD_CONFIG_OS_WIN32 )
        return LocationResolverManagerFactory::CreateSharedEmplaced<ILocationResolverManager, LocationResolverManagerImpl>();
#elif defined( NN_BUILD_CONFIG_OS_HORIZON )
        sf::SharedPointer<ILocationResolverManager> p;
        NN_ABORT_UNLESS((sf::CreateHipcProxyByName<ILocationResolverManager, MyAllocator::Policy>(&p, LocationResolverServiceName)).IsSuccess());
        return p;
#else
    #error "unsupported os"
#endif
    }
}}
