﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>

#include <nn/lr/lr_AddOnContentLocationResolver.h>
#include <nn/lr/lr_IAddOnContentLocationResolver.h>

namespace nn { namespace lr {

Result AddOnContentLocationResolver::ResolveAddOnContentPath(Path* outValue, ncm::DataId id) NN_NOEXCEPT
{
    NN_SDK_ASSERT(m_Interface);

    return m_Interface->ResolveAddOnContentPath(outValue, id);
}

Result AddOnContentLocationResolver::RegisterAddOnContentStorage(ncm::DataId id, ncm::StorageId storageId) NN_NOEXCEPT
{
    NN_SDK_ASSERT(m_Interface);

    return m_Interface->RegisterAddOnContentStorage(id, storageId);
}

void AddOnContentLocationResolver::UnregisterAllAddOnContentPath() NN_NOEXCEPT
{
    NN_SDK_ASSERT(m_Interface);

    NN_ABORT_UNLESS_RESULT_SUCCESS(m_Interface->UnregisterAllAddOnContentPath());
}

}}
