﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using nn;
using nn.sf;
using std;

namespace nn.ncm
{
    [CppRefPath(@"<nn/ncm/ncm_ProgramLocation.h>")]
    [ExternalStruct(16, 8)]
    public struct ProgramLocation
    {
    }
}

namespace nn.ldr
{
    [CppRefPath(@"<nn/ldr/ldr_Types.h>")]
    [LargeData]
    [ExternalStruct(1024, 8)]
    public struct ProgramInfo
    {
    }

    [CppRefPath(@"<nn/ldr/ldr_Types.h>")]
    [ExternalStruct(8, 8)]
    public struct PinId
    {
    }

    namespace detail
    {
        public interface IProcessManagerInterface : IServiceObject
        {
            [MethodId(0)]
            Result
                CreateProcess(
                    [MoveHandle] Out<NativeHandle>  pOut,
                    PinId                           pinId,
                    int32_t                         flags,
                    NativeHandle                    resourceLimit
                );

            [MethodId(1)]
            Result
                GetProgramInfo(
                    Out<ProgramInfo>        pOut,
                    nn.ncm.ProgramLocation  location
                );

            [MethodId(2)]
            Result
                PinProgram(
                    Out<PinId>                      pOut,
                    nn.ncm.ProgramLocation          programLocation
                );

            [MethodId(3)]
            Result
                UnpinProgram(
                    PinId                           pinId
                );
        }
    }
}
