﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using nn;
using nn.sf;
using std;

namespace nn.ncm
{
    [CppRefPath(@"<nn/ncm/ncm_ProgramId.h>")]
    [ExternalStruct(8, 8)]
    public struct ProgramId
    {
    }
}

namespace nn.os
{
    [CppRefPath(@"<nn/os/os_Types.h>")]
    [ExternalStruct(8, 8)]
    public struct ProcessId
    {
    }
}

namespace nn.ldr
{
    [CppRefPath(@"<nn/ldr/ldr_Types.h>")]
    public struct ModuleInfo
    {
        [FixedArray(32)]
        public Bit8[]   moduleId;
        public uint64_t address;
        public uint64_t size;
    }
}

namespace nn.ldr
{
    namespace detail
    {
        public interface IDebugMonitorInterface : IServiceObject
        {
            [MethodId(0)]
            Result
                SetProgramArgument2(
                    nn.ncm.ProgramId    programId,
                    InArray<nn.Bit8>    argument,
                    uint32_t            size
                );

            [MethodId(1)]
            Result
                FlushArguments2(
                );

            [MethodId(2)]
            Result
                GetProcessModuleInfo(
                    Out<int32_t>                pOutCount,
                    OutArray<ldr.ModuleInfo>    pOutModules,
                    os.ProcessId                id
                );
        }
    }
}
