﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>
#include <nn/result/result_HandlingUtility.h>
#include <nn/kvdb/kvdb_Result.h>
#include <nn/kvdb/kvdb_AutoBuffer.h>

namespace nn { namespace kvdb {
    Result AutoBuffer::Initialize(size_t size) NN_NOEXCEPT
    {
        NN_SDK_ASSERT(!m_Buffer.get());

        auto p = new char[size];
        NN_RESULT_THROW_UNLESS(p, ResultAllocationMemoryFailed());

        m_Buffer.reset(p);
        m_Size = size;

        NN_RESULT_SUCCESS;
    }

    Result AutoBuffer::Initialize(const void* data, size_t size) NN_NOEXCEPT
    {
        NN_RESULT_DO(Initialize(size));
        std::memcpy(m_Buffer.get(), data, size);

        NN_RESULT_SUCCESS;
    }
}}
