﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/TargetConfigs/build_Compiler.h>
#include <nn/diag/text/diag_SdkTextInit.h>

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Abort.h>
#include <nn/nn_Windows.h>

#if defined(NN_BUILD_CONFIG_COMPILER_VC)
    // 日本語以外の環境で表示される文字コードエンコーディングに関する警告の抑制
    #pragma warning( disable : 4566 )
#endif

namespace nn { namespace init { namespace detail {

//-----------------------------------------------------------------------------
//  Win32 用の nninitStartup() 関数のデフォルト実装
//
void StartupDefaultForWin32() NN_NOEXCEPT
{
#if 1
    // TORIAEZU:
    // Win32 環境での nninitStartup() 関数は、現状 libnn_os ライブラリの
    // nnosInitialize() から呼ばれる形になっている。将来的に crt0 相当の
    // 初期化コードから呼ばれるような実装になった時に、多重呼び出しされた
    // 場合でも気付けるように多重呼び出しチェックを入れておく。

    static bool s_AlreadyCalled = false;
    NN_ABORT_UNLESS(!s_AlreadyCalled, NN_TEXT_INIT("Win32: nninitStartup() が多重に呼び出されました。"));
    s_AlreadyCalled = true;
#endif
}

//-----------------------------------------------------------------------------

}}} // namespace nn::init::detail

