﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Windows.h>

namespace nn { namespace hws {

class MsgProc
{
public:
    static MsgProc& GetInstance()
    {
        static MsgProc instance;
        return instance;
    }

    static LRESULT CALLBACK MsgProcCallback( HWND hWnd, UINT msg, WPARAM wparam, LPARAM lparam )
    {
        return GetInstance().MsgProcImpl( hWnd, msg, wparam, lparam );
    }

    int GetMouseWheel()
    {
        return m_MouseWheel;
    }
    void ResetMouseWheel()
    {
        m_MouseWheel = 0;
    }

private:
    LRESULT MsgProcImpl( HWND hWnd, UINT msg, WPARAM wparam, LPARAM lparam );

    int m_MouseWheel;

    MsgProc()
        : m_MouseWheel()
    {
    }
    ~MsgProc()
    {
    }

    NN_DISALLOW_COPY( MsgProc );
};

}
} // wnd
