﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

// 以下は固定で using を推奨
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using nn;
using nn.sf;
using std;

namespace nn.htclow.detail
{
    [CppRefPath(@"<nn/htclow/detail/htclow_InternalTypes.h>")]
    [ExternalStruct(4, 4)]
    public struct ChannelInternalType{}
}

namespace nn.htclow.detail
{
    [CppRefPath(@"<nn/htclow/detail/htclow_IUserServiceObject.h>")]
    public interface IUserServiceObject: IServiceObject
    {
        [MethodId(0)]
        Result Open(nn.htclow.detail.ChannelInternalType channel);

        [MethodId(1)]
        Result Close(nn.htclow.detail.ChannelInternalType channel);

        [MethodId(2)]
        Result Connect(nn.htclow.detail.ChannelInternalType channel);

        [MethodId(3)]
        Result Shutdown(nn.htclow.detail.ChannelInternalType channel);

        [MethodId(4)]
        Result Receive(Out<uint64_t> outSize, OutBuffer outBuffer, nn.htclow.detail.ChannelInternalType channel);

        [MethodId(5)]
        Result Send(Out<uint64_t> outSize, InBuffer buffer, nn.htclow.detail.ChannelInternalType channel);

        [MethodId(6)]
        Result GetClosedEvent(Out<NativeHandle> outHandle, nn.htclow.detail.ChannelInternalType channel);

        [MethodId(7)]
        Result GetEstablishedEvent(Out<NativeHandle> outHandle, nn.htclow.detail.ChannelInternalType channel);

        [MethodId(8)]
        Result GetReceiveReadyEvent(Out<NativeHandle> outHandle, nn.htclow.detail.ChannelInternalType channel);

        [MethodId(9)]
        Result GetSendReadyEvent(Out<NativeHandle> outHandle, nn.htclow.detail.ChannelInternalType channel);

        [MethodId(10)]
        Result GetSendCompleteEvent(Out<NativeHandle> outHandle, nn.htclow.detail.ChannelInternalType channel);

        [MethodId(11)]
        Result GetHostConnectEvent(Out<NativeHandle> outHandle);

        [MethodId(12)]
        Result GetHostDisconnectEvent(Out<NativeHandle> outHandle);
    }
}
