﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>

#include <nn/htclow/htclow_ModuleApi.h>

namespace nn {
namespace htclow {

void InitializeModule(ModuleType* pOutModule, ModuleId id) NN_NOEXCEPT
{
    pOutModule->_id = id;
    pOutModule->_isInitialized = true;
}

void FinalizeModule(ModuleType* pOutModule) NN_NOEXCEPT
{
    pOutModule->_id = static_cast<ModuleId>(0);
    pOutModule->_isInitialized = false;
}

}}
