﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>

#include <nn/htclow/htclow_ChannelApi.h>

namespace nn {
namespace htclow {

void InitializeChannel(ChannelType* pOutChannel, const ModuleType* pModule, ChannelId id) NN_NOEXCEPT
{
    pOutChannel->_moduleId = pModule->_id;
    pOutChannel->_channelId = id;
    pOutChannel->_isInitialized = true;
}

void FinalizeChannel(ChannelType* pOutChannel) NN_NOEXCEPT
{
    pOutChannel->_moduleId = static_cast<ModuleId>(0);
    pOutChannel->_channelId = static_cast<ChannelId>(0);
    pOutChannel->_isInitialized = false;
}

}}
