﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/htc/tenv/htc_TenvServiceManager.h>

#include "htc_TenvAllocator.h"
#include "htc_TenvService.h"

namespace nn { namespace htc { namespace tenv {

    Result ServiceManager::GetServiceInterface(nn::sf::Out<nn::sf::SharedPointer<nn::htc::tenv::IService>> outValue, nn::Bit64 processId) NN_NOEXCEPT
    {
        outValue.Set(detail::ObjectFactory::CreateSharedEmplaced<nn::htc::tenv::IService, Service>(processId));
        NN_RESULT_SUCCESS;
    }

}}}
