﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

// このファイルはユーザ定義

#include <nn/sf/sf_HipcClientProxyByName.h>
#include <nn/sf/sf_ExpHeapAllocator.h>
#include "htc_HtcManagerByHipc.h"
#include <nn/htc/detail/htc_ServiceName.h>

namespace nn { namespace htc {

namespace {

// 拡張ヒープを使用したアロケータを、HIPC プロキシ用に準備
struct CreateHtcManagerByHipcTag;
typedef nn::sf::ExpHeapStaticAllocator<1024 * 16, CreateHtcManagerByHipcTag> MyAllocator;

// MyAllocator を静的コンストラクタで初期化するためのヘルパー
class MyAllocatorInitializer
{
public:

    MyAllocatorInitializer() NN_NOEXCEPT
    {
        MyAllocator::Initialize(nn::lmem::CreationOption_ThreadSafe);
    }

} g_MyAllocatorInitializer;
}

nn::sf::SharedPointer<tma::IHtcManager> CreateHtcManagerByHipc() NN_NOEXCEPT
{
    nn::sf::SharedPointer<tma::IHtcManager> ret;
    auto result = nn::sf::CreateHipcProxyByName<tma::IHtcManager, MyAllocator::Policy>(&ret, detail::HtcServiceName);
    NN_ABORT_UNLESS(result.IsSuccess());
    return ret;
}

}}
