﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nn;
using nn.sf;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using std;

namespace nn.tma
{
    [CppRefPath(@"<nn/htc/htc_IHtcManager.h>")]
    public interface IHtcManager : IServiceObject
    {
        [MethodId(0)]
        Result GetEnvironmentVariable         ( Out<int32_t>        pOutSize,
                                                OutBuffer           outBuffer,
                                                InBuffer            variableName );

        [MethodId(1)]
        Result GetEnvironmentVariableLength   ( Out<int32_t>        pOutValue,
                                                InBuffer            variableName );

        [MethodId(2)]
        Result GetHostConnectionEvent         ( Out<NativeHandle>   pOutValue );

        [MethodId(3)]
        Result GetHostDisconnectionEvent      ( Out<NativeHandle>   pOutValue );

        [MethodId(4)]
        Result GetHostConnectionEventForSystem ( Out<NativeHandle>   pOutValue );

        [MethodId(5)]
        Result GetHostDisconnectionEventForSystem ( Out<NativeHandle>   pOutValue );

        [MethodId(6)]
        Result GetBridgeIpAddress             ( OutBuffer           outBuffer );

        [MethodId(7)]
        Result GetBridgePort                  ( OutBuffer           outBuffer );

        [MethodId(8)]
        Result SetCradleAttached              ( bool                bAttached );

        [MethodId(9)]
        Result GetBridgeSubnetMask            ( OutBuffer           outBuffer );

        [MethodId(10)]
        Result GetBridgeMacAddress            ( OutBuffer           outBuffer );

        [MethodId(11)]
        Result GetWorkingDirectoryPath        ( OutBuffer           pOutValue,
                                                int32_t             bufferSize );

        [MethodId(12)]
        Result GetWorkingDirectoryPathSize    ( Out<int32_t>        pOutValue );
    }
}
