﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/gc/detail/gc_AsicOperation.h>
#include <nn/gc/detail/gc_Util.h>

namespace nn { namespace gc {
namespace detail {

void AsicOperationCardCommandBuffer::SetCommandBufferForAsic(const DataPageSize dataPageSize, const DataTransDirectionForCard DataTransDirectionForCard, const u32 pageCount) NN_NOEXCEPT
{
    // 0 でないところだけセット
    bufferMap.operationId   = static_cast<u8>(AsicOperationIndex_CARD_CMDOUT);
    bufferMap.dataPageSize  = static_cast<u8>(dataPageSize);
    bufferMap.dataDirection = static_cast<u8>(DataTransDirectionForCard);
    bufferMap.dataPageNum   = pageCount;
}

void AsicOperationCardCommandBuffer::SetCommandBufferForGc(const CardCommandId command, const u32 pageAddress, const u32 pageCount) NN_NOEXCEPT
{
    // 0 でないところだけセット
    bufferMap.commandBuffer[0] = static_cast<u8>(command);
    bufferMap.commandBuffer[1] = (pageAddress >> 24) & 0xFF;
    bufferMap.commandBuffer[2] = (pageAddress >> 16) & 0xFF;
    bufferMap.commandBuffer[3] = (pageAddress >>  8) & 0xFF;
    bufferMap.commandBuffer[4] = (pageAddress >>  0) & 0xFF;
    bufferMap.commandBuffer[5] = (pageCount >> 16) & 0xFF;
    bufferMap.commandBuffer[6] = (pageCount >>  8) & 0xFF;
    bufferMap.commandBuffer[7] = (pageCount >>  0) & 0xFF;
}

void AsicOperationCardCommandBuffer::GetCommandBufferWithNoData(char* outOperationBuffer, size_t outOperationBufferSize, const CardCommandId command, const DataPageSize dataPageSize) NN_NOEXCEPT
{
    // 64 Byte 0 セット
    memset(&bufferMap, 0, GcMmcCmd60DataSize);
    SetCommandBufferForAsic(dataPageSize, DataTransDirectionForCard_Read, 0);
    SetCommandBufferForGc(command, 0, 0);
    CopyBuffer(outOperationBuffer,outOperationBufferSize);
}

void AsicOperationCardCommandBuffer::GetCommandBufferWithPageRead(char* outOperationBuffer, size_t outOperationBufferSize, const CardCommandId command, const u32 pageAddress, const u32 pageCount) NN_NOEXCEPT
{
    // 64 Byte 0 セット
    memset(&bufferMap, 0, GcMmcCmd60DataSize);
    SetCommandBufferForAsic(DataPageSize_512Byte, DataTransDirectionForCard_Read, pageCount);
    SetCommandBufferForGc(command, pageAddress, pageCount);
    CopyBuffer(outOperationBuffer,outOperationBufferSize);
}

void AsicOperationCardCommandBuffer::GetCommandBufferWithPageWrite(char* outOperationBuffer, size_t outOperationBufferSize, const CardCommandId command, const u32 pageAddress, const u32 pageCount) NN_NOEXCEPT
{
    // 64 Byte 0 セット
    memset(&bufferMap, 0, GcMmcCmd60DataSize);
    SetCommandBufferForAsic(DataPageSize_512Byte, DataTransDirectionForCard_Write, pageCount);
    SetCommandBufferForGc(command, pageAddress, pageCount);
    CopyBuffer(outOperationBuffer,outOperationBufferSize);
}

void AsicOperationCardCommandBuffer::GetCommandBufferDirectly(char* outOperationBuffer, size_t outOperationBufferSize, const DataPageSize dataPageSize, const DataTransDirectionForCard dataDirection, const u32 dataPageNum, const CardCommandId command, const u32 pageAddress, const u32 pageCount) NN_NOEXCEPT
{
    // 64 Byte 0 セット
    memset(&bufferMap, 0, GcMmcCmd60DataSize);
    SetCommandBufferForAsic(dataPageSize, dataDirection, dataPageNum);
    SetCommandBufferForGc(command, pageAddress, pageCount);
    CopyBuffer(outOperationBuffer,outOperationBufferSize);
}

void AsicOperationCardCommandBuffer::CopyBuffer(char* outOperationBuffer, size_t outOperationBufferSize) NN_NOEXCEPT
{
    NN_DETAIL_GC_ABORT_UNLESS_SDK_REQUIRES(outOperationBufferSize >= sizeof(AsicOperationCardCommand));
    memcpy(outOperationBuffer, &bufferMap, sizeof(AsicOperationCardCommand));
}

} } }
