﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <atomic>
#include <nn/fssystem/fs_SpeedEmulationConfiguration.h>

namespace nn { namespace fssystem {

namespace {
    std::atomic<nn::fs::SpeedEmulationMode> g_SpeedEmulationMode(nn::fs::SpeedEmulationMode::None);
}

void SpeedEmulationConfiguration::SetSpeedEmulationMode(nn::fs::SpeedEmulationMode mode) NN_NOEXCEPT
{
    g_SpeedEmulationMode = mode;
}

nn::fs::SpeedEmulationMode SpeedEmulationConfiguration::GetSpeedEmulationMode() NN_NOEXCEPT
{
    return g_SpeedEmulationMode;
}

}}

