﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdlib>
#include <nn/nn_SdkAssert.h>
#include <nn/fssystem/fs_AllocatorUtility.h>

namespace nn { namespace fssystem {

    namespace {
#if defined(NN_BUILD_CONFIG_OS_WIN32)
        bool g_UseDefault = false;

        void* DefaultAllocate(size_t size) NN_NOEXCEPT
        {
            g_UseDefault = true;
            return std::malloc(size);
        }

        void DefaultDeallocate(void* p, size_t size) NN_NOEXCEPT
        {
            NN_UNUSED(size);
            std::free(p);
        }

        AllocateFunction g_AllocateFunction = DefaultAllocate;
        DeallocateFunction g_DeallocateFunction = DefaultDeallocate;
#else
        AllocateFunction g_AllocateFunction = nullptr;
        DeallocateFunction g_DeallocateFunction = nullptr;
#endif
    }

    void* Allocate(size_t size) NN_NOEXCEPT
    {
        NN_SDK_ASSERT_NOT_NULL(g_AllocateFunction);
        return g_AllocateFunction(size);
    }

    void Deallocate(void* p, size_t size) NN_NOEXCEPT
    {
        NN_SDK_ASSERT_NOT_NULL(g_DeallocateFunction);
        g_DeallocateFunction(p, size);
    }

    void InitializeAllocator(AllocateFunction alloc, DeallocateFunction dealloc) NN_NOEXCEPT
    {
        NN_SDK_ASSERT_NOT_NULL(alloc);
        NN_SDK_ASSERT_NOT_NULL(dealloc);

#if defined(NN_BUILD_CONFIG_OS_WIN32)
        NN_SDK_REQUIRES(g_UseDefault == false);
#else
        NN_SDK_REQUIRES(g_AllocateFunction == nullptr);
        NN_SDK_REQUIRES(g_DeallocateFunction == nullptr);
#endif

        g_AllocateFunction = alloc;
        g_DeallocateFunction = dealloc;
    }

}}
