﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;
using nn;
using nn.sf;
using std;

namespace nn.fs
{
    [CppRefPath(@"<nn/fs/fs_QueryRange.h>")]
    [ExternalStruct(64, 8)]
    public struct StorageQueryRangeInfo
    {
    }
}

namespace nn.fssrv.sf
{
    [CppRefPath(@"<nn/fssrv/sf/fssrv_IStorage.h>")]
    public interface IStorage : IServiceObject
    {
        [MethodId(0)]
        Result Read(int64_t offset, [NonSecureMapTransfer] OutBuffer buffer, int64_t size);

        [MethodId(1)]
        Result Write(int64_t offset, [NonSecureMapTransfer] InBuffer buffer, int64_t size);

        [MethodId(2)]
        Result Flush();

        [MethodId(3)]
        Result SetSize(int64_t size);

        [MethodId(4)]
        Result GetSize(Out<int64_t> outValue);

        [MethodId(5)]
        Result OperateRange(Out<nn.fs.StorageQueryRangeInfo> outQueryRangeInfo, int32_t operationId,  int64_t offset, int64_t size);
    }
}
