﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;
using nn;
using nn.sf;
using std;

namespace nn.fssrv.sf
{
    [CppRefPath(@"<nn/fssrv/sf/fssrv_IProgramRegistry.h>")]
    public interface IProgramRegistry : IServiceObject
    {
        [MethodId(0)]
        Result RegisterProgram(uint64_t processId, uint64_t programId, uint8_t storageId, InBuffer fsAccessControlData, int64_t dataSize, InBuffer fsAccessControlDesc, int64_t descSize);

        [MethodId(1)]
        Result UnregisterProgram(uint64_t processId);

        [MethodId(2)]
        Result SetCurrentProcess([ProcessId] nn.Bit64 processId);

        [MethodId(256)]
        Result SetEnabledProgramVerification(bool isEnabled);
    }
}
