﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/fs/fs_Result.h>
#include <nn/fs/fs_ResultPrivate.h>
#include <nn/fssrv/fssrv_ProgramRegistryImpl.h>

#include "detail/fssrv_ProgramInfo.h"
#include "detail/fssrv_ProgramRegistryManager.h"
#include "detail/fssrv_RuntimeConfiguration.h"

namespace nn { namespace fssrv {

    namespace {
        detail::ProgramRegistryManager* GetProgramRegistryManager()
        {
            NN_FUNCTION_LOCAL_STATIC(nn::fssrv::detail::ProgramRegistryManager, g_ProgramRegistryManager,);
            return &g_ProgramRegistryManager;
        }
    }

    ProgramRegistryImpl::ProgramRegistryImpl() NN_NOEXCEPT : m_ProcessId(0xFFFFFFFFFFFFFFFF)
    {
    }

    ProgramRegistryImpl::~ProgramRegistryImpl() NN_NOEXCEPT
    {
    }

    Result ProgramRegistryImpl::RegisterProgram(std::uint64_t processId, std::uint64_t programId, uint8_t storageId, const nn::sf::InBuffer& fsAccessControlData, std::int64_t dataSize, const nn::sf::InBuffer& fsAccessControlDesc, std::int64_t descSize) NN_NOEXCEPT
    {
        NN_RESULT_THROW_UNLESS(detail::IsInitialProgram(m_ProcessId), nn::fs::ResultPermissionDenied());
        return GetProgramRegistryManager()->RegisterProgram(processId, programId, storageId, fsAccessControlData.GetPointerUnsafe(), dataSize, fsAccessControlDesc.GetPointerUnsafe(), descSize);
    }

    Result ProgramRegistryImpl::UnregisterProgram(std::uint64_t processId) NN_NOEXCEPT
    {
        NN_RESULT_THROW_UNLESS(detail::IsInitialProgram(m_ProcessId), nn::fs::ResultPermissionDenied());
        return GetProgramRegistryManager()->UnregisterProgram(processId);
    }

    Result ProgramRegistryImpl::SetEnabledProgramVerification(bool isEnabled) NN_NOEXCEPT
    {
        NN_RESULT_THROW_UNLESS(detail::IsInitialProgram(m_ProcessId), nn::fs::ResultPermissionDenied());
        nn::fssrv::detail::SetEnabledProgramVerification(isEnabled);
        NN_RESULT_SUCCESS;
    }

    Result ProgramRegistryImpl::GetProgramInfo(std::shared_ptr<detail::ProgramInfo>* pOutValue, uint64_t processId) NN_NOEXCEPT
    {
        return GetProgramRegistryManager()->GetProgramInfo(pOutValue, processId);
    }

    Result ProgramRegistryImpl::GetProgramInfoByProgramId(std::shared_ptr<detail::ProgramInfo>* pOutValue, Bit64 programId) NN_NOEXCEPT
    {
        return GetProgramRegistryManager()->GetProgramInfoByProgramId(pOutValue, programId);
    }

    Result ProgramRegistryImpl::SetCurrentProcess(nn::Bit64 processId) NN_NOEXCEPT
    {
        m_ProcessId = processId;
        NN_RESULT_SUCCESS;
    }
}}
