﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/fssrv/fssrv_MemoryResourceFromStandardAllocator.h>
#include <nn/mem/mem_StandardAllocator.h>

namespace nn { namespace fssrv {

    MemoryResourceFromStandardAllocator::MemoryResourceFromStandardAllocator(nn::mem::StandardAllocator* pAllocator) NN_NOEXCEPT
    {
        m_Allocator = pAllocator;
        m_SizeFreeInitial = m_Allocator->GetTotalFreeSize();
        ClearPeak();
    }

    void MemoryResourceFromStandardAllocator::ClearPeak() NN_NOEXCEPT
    {
        m_SizeFreePeak = m_Allocator->GetTotalFreeSize();
    }

    void* MemoryResourceFromStandardAllocator::do_allocate(std::size_t bytes, std::size_t alignment) NN_NOEXCEPT
    {
        void* buffer = m_Allocator->Allocate(bytes, alignment);
        const size_t freeSize = m_Allocator->GetTotalFreeSize();
        if( freeSize < m_SizeFreePeak )
        {
            m_SizeFreePeak = freeSize;
        }
        return buffer;
    }

    void MemoryResourceFromStandardAllocator::do_deallocate(void* p, std::size_t bytes, std::size_t alignment) NN_NOEXCEPT
    {
        NN_UNUSED(bytes);
        NN_UNUSED(alignment);

        m_Allocator->Free(p);
    }

}}
