﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "fssrv_SdmmcResultConverter.h"
#include <nn/fs/fs_Result.h>
#include <nn/fs/fs_ResultPrivate.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/nn_SdkLog.h>

namespace nn { namespace fssrv { namespace detail {

using namespace nn::fs;

#define NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(type, fsResult) \
    do \
    { \
        if (type::Includes(sdmmcResult)) \
        { \
            NN_SDK_LOG("[fs] Warning: nn::fs::" #fsResult " is detected.\n"); \
            NN_RESULT_THROW(fsResult); \
        } \
    } while (NN_STATIC_CONDITION(0))

namespace {

    Result GetFsResultFromMmcResult(Result sdmmcResult) NN_NOEXCEPT
    {
        // GetFsResult() と重複するが関数単体として念のため
        if (sdmmcResult.IsSuccess())
        {
            NN_RESULT_SUCCESS;
        }

        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultNoDevice, ResultPortMmcNoDevice());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultNotActivated, ResultPortMmcNotActivated());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultDeviceRemoved, ResultPortMmcDeviceRemoved());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultNotAwakened, ResultPortMmcNotAwakened());

        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultResponseIndexError, ResultPortMmcResponseIndexError());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultResponseEndBitError, ResultPortMmcResponseEndBitError());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultResponseCrcError, ResultPortMmcResponseCrcError());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultResponseTimeoutError, ResultPortMmcResponseTimeoutError());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultDataEndBitError, ResultPortMmcDataEndBitError());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultDataCrcError, ResultPortMmcDataCrcError());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultDataTimeoutError, ResultPortMmcDataTimeoutError());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultAutoCommandResponseIndexError, ResultPortMmcAutoCommandResponseIndexError());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultAutoCommandResponseEndBitError, ResultPortMmcAutoCommandResponseEndBitError());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultAutoCommandResponseCrcError, ResultPortMmcAutoCommandResponseCrcError());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultAutoCommandResponseTimeoutError, ResultPortMmcAutoCommandResponseTimeoutError());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultCommandCompleteSwTimeout, ResultPortMmcCommandCompleteSwTimeout());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultTransferCompleteSwTimeout, ResultPortMmcTransferCompleteSwTimeout());

        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultDeviceStatusAddressOutOfRange, ResultPortMmcDeviceStatusAddressOutOfRange());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultDeviceStatusAddressMisalign, ResultPortMmcDeviceStatusAddressMisalign());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultDeviceStatusBlockLenError, ResultPortMmcDeviceStatusBlockLenError());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultDeviceStatusEraseSeqError, ResultPortMmcDeviceStatusEraseSeqError());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultDeviceStatusEraseParam, ResultPortMmcDeviceStatusEraseParam());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultDeviceStatusWpViolation, ResultPortMmcDeviceStatusWpViolation());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultDeviceStatusLockUnlockFailed, ResultPortMmcDeviceStatusLockUnlockFailed());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultDeviceStatusComCrcError, ResultPortMmcDeviceStatusComCrcError());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultDeviceStatusIllegalCommand, ResultPortMmcDeviceStatusIllegalCommand());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultDeviceStatusDeviceEccFailed, ResultPortMmcDeviceStatusDeviceEccFailed());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultDeviceStatusCcError, ResultPortMmcDeviceStatusCcError());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultDeviceStatusError, ResultPortMmcDeviceStatusError());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultDeviceStatusCidCsdOverwrite, ResultPortMmcDeviceStatusCidCsdOverwrite());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultDeviceStatusWpEraseSkip, ResultPortMmcDeviceStatusWpEraseSkip());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultDeviceStatusEraseReset, ResultPortMmcDeviceStatusEraseReset());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultDeviceStatusSwitchError, ResultPortMmcDeviceStatusSwitchError());

        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultUnexpectedDeviceState, ResultPortMmcUnexpectedDeviceState());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultUnexpectedDeviceCsdValue, ResultPortMmcUnexpectedDeviceCsdValue());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultAbortTransactionSwTimeout, ResultPortMmcAbortTransactionSwTimeout());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultCommandInhibitCmdSwTimeout, ResultPortMmcCommandInhibitCmdSwTimeout());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultCommandInhibitDatSwTimeout, ResultPortMmcCommandInhibitDatSwTimeout());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultBusySwTimeout, ResultPortMmcBusySwTimeout());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultIssueTuningCommandSwTimeout, ResultPortMmcIssueTuningCommandSwTimeout());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultTuningFailed, ResultPortMmcTuningFailed());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultMmcInitializationSwTimeout, ResultPortMmcMmcInitializationSwTimeout());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultMmcNotSupportExtendedCsd, ResultPortMmcMmcNotSupportExtendedCsd());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultUnexpectedMmcExtendedCsdValue, ResultPortMmcUnexpectedMmcExtendedCsdValue());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultMmcEraseSwTimeout, ResultPortMmcMmcEraseSwTimeout());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultSdCardValidationError, ResultPortMmcSdCardValidationError());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultSdCardInitializationSwTimeout, ResultPortMmcSdCardInitializationSwTimeout());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultSdCardGetValidRcaSwTimeout, ResultPortMmcSdCardGetValidRcaSwTimeout());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultUnexpectedSdCardAcmdDisabled, ResultPortMmcUnexpectedSdCardAcmdDisabled());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultSdCardNotSupportSwitchFunctionStatus, ResultPortMmcSdCardNotSupportSwitchFunctionStatus());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultUnexpectedSdCardSwitchFunctionStatus, ResultPortMmcUnexpectedSdCardSwitchFunctionStatus());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultSdCardNotSupportAccessMode, ResultPortMmcSdCardNotSupportAccessMode());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultSdCardNot4BitBusWidthAtUhsIMode, ResultPortMmcSdCardNot4BitBusWidthAtUhsIMode());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultSdCardNotSupportSdr104AndSdr50, ResultPortMmcSdCardNotSupportSdr104AndSdr50());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultSdCardCannotSwitchedAccessMode, ResultPortMmcSdCardCannotSwitchedAccessMode());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultSdCardFailedSwitchedAccessMode, ResultPortMmcSdCardFailedSwitchedAccessMode());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultSdCardUnacceptableCurrentConsumption, ResultPortMmcSdCardUnacceptableCurrentConsumption());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultSdCardNotReadyToVoltageSwitch, ResultPortMmcSdCardNotReadyToVoltageSwitch());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultSdCardNotCompleteVoltageSwitch, ResultPortMmcSdCardNotCompleteVoltageSwitch());

        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultInternalClockStableSwTimeout, ResultPortMmcInternalClockStableSwTimeout());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultSdHostStandardUnknownAutoCmdError, ResultPortMmcSdHostStandardUnknownAutoCmdError());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultSdHostStandardUnknownError, ResultPortMmcSdHostStandardUnknownError());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultSdmmcDllCalibrationSwTimeout, ResultPortMmcSdmmcDllCalibrationSwTimeout());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultSdmmcDllApplicationSwTimeout, ResultPortMmcSdmmcDllApplicationSwTimeout());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultSdHostStandardFailSwitchTo18V, ResultPortMmcSdHostStandardFailSwitchTo18V());

        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultNoWaitedInterrupt, ResultPortMmcNoWaitedInterrupt());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultWaitInterruptSwTimeout, ResultPortMmcWaitInterruptSwTimeout());

        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultAbortCommandIssued, ResultPortMmcAbortCommandIssued());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultNotSupported, ResultPortMmcNotSupported());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultNotImplemented, ResultPortMmcNotImplemented());

        NN_SDK_LOG("[fs] Warning: Unexpected Result(Module:%d, Description:%d) is detected.\n", sdmmcResult.GetModule(), sdmmcResult.GetDescription());
        // その他の Result は全て ResultMmcAccessFailed() 内の ResultPortMmcUnexpected() に丸める
        return ResultPortMmcUnexpected();
    }

    Result GetFsResultFromSdCardResult(Result sdmmcResult) NN_NOEXCEPT
    {
        // GetFsResult() と重複するが関数単体として念のため
        if (sdmmcResult.IsSuccess())
        {
            NN_RESULT_SUCCESS;
        }

        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultNoDevice, ResultPortSdCardNoDevice());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultNotActivated, ResultPortSdCardNotActivated());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultDeviceRemoved, ResultPortSdCardDeviceRemoved());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultNotAwakened, ResultPortSdCardNotAwakened());

        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultResponseIndexError, ResultPortSdCardResponseIndexError());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultResponseEndBitError, ResultPortSdCardResponseEndBitError());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultResponseCrcError, ResultPortSdCardResponseCrcError());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultResponseTimeoutError, ResultPortSdCardResponseTimeoutError());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultDataEndBitError, ResultPortSdCardDataEndBitError());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultDataCrcError, ResultPortSdCardDataCrcError());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultDataTimeoutError, ResultPortSdCardDataTimeoutError());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultAutoCommandResponseIndexError, ResultPortSdCardAutoCommandResponseIndexError());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultAutoCommandResponseEndBitError, ResultPortSdCardAutoCommandResponseEndBitError());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultAutoCommandResponseCrcError, ResultPortSdCardAutoCommandResponseCrcError());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultAutoCommandResponseTimeoutError, ResultPortSdCardAutoCommandResponseTimeoutError());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultCommandCompleteSwTimeout, ResultPortSdCardCommandCompleteSwTimeout());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultTransferCompleteSwTimeout, ResultPortSdCardTransferCompleteSwTimeout());

        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultDeviceStatusAddressOutOfRange, ResultPortSdCardDeviceStatusAddressOutOfRange());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultDeviceStatusAddressMisalign, ResultPortSdCardDeviceStatusAddressMisalign());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultDeviceStatusBlockLenError, ResultPortSdCardDeviceStatusBlockLenError());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultDeviceStatusEraseSeqError, ResultPortSdCardDeviceStatusEraseSeqError());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultDeviceStatusEraseParam, ResultPortSdCardDeviceStatusEraseParam());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultDeviceStatusWpViolation, ResultPortSdCardDeviceStatusWpViolation());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultDeviceStatusLockUnlockFailed, ResultPortSdCardDeviceStatusLockUnlockFailed());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultDeviceStatusComCrcError, ResultPortSdCardDeviceStatusComCrcError());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultDeviceStatusIllegalCommand, ResultPortSdCardDeviceStatusIllegalCommand());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultDeviceStatusDeviceEccFailed, ResultPortSdCardDeviceStatusDeviceEccFailed());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultDeviceStatusCcError, ResultPortSdCardDeviceStatusCcError());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultDeviceStatusError, ResultPortSdCardDeviceStatusError());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultDeviceStatusCidCsdOverwrite, ResultPortSdCardDeviceStatusCidCsdOverwrite());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultDeviceStatusWpEraseSkip, ResultPortSdCardDeviceStatusWpEraseSkip());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultDeviceStatusEraseReset, ResultPortSdCardDeviceStatusEraseReset());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultDeviceStatusSwitchError, ResultPortSdCardDeviceStatusSwitchError());

        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultUnexpectedDeviceState, ResultPortSdCardUnexpectedDeviceState());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultUnexpectedDeviceCsdValue, ResultPortSdCardUnexpectedDeviceCsdValue());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultAbortTransactionSwTimeout, ResultPortSdCardAbortTransactionSwTimeout());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultCommandInhibitCmdSwTimeout, ResultPortSdCardCommandInhibitCmdSwTimeout());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultCommandInhibitDatSwTimeout, ResultPortSdCardCommandInhibitDatSwTimeout());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultBusySwTimeout, ResultPortSdCardBusySwTimeout());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultIssueTuningCommandSwTimeout, ResultPortSdCardIssueTuningCommandSwTimeout());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultTuningFailed, ResultPortSdCardTuningFailed());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultMmcInitializationSwTimeout, ResultPortSdCardMmcInitializationSwTimeout());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultMmcNotSupportExtendedCsd, ResultPortSdCardMmcNotSupportExtendedCsd());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultUnexpectedMmcExtendedCsdValue, ResultPortSdCardUnexpectedMmcExtendedCsdValue());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultMmcEraseSwTimeout, ResultPortSdCardMmcEraseSwTimeout());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultSdCardValidationError, ResultPortSdCardSdCardValidationError());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultSdCardInitializationSwTimeout, ResultPortSdCardSdCardInitializationSwTimeout());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultSdCardGetValidRcaSwTimeout, ResultPortSdCardSdCardGetValidRcaSwTimeout());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultUnexpectedSdCardAcmdDisabled, ResultPortSdCardUnexpectedSdCardAcmdDisabled());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultSdCardNotSupportSwitchFunctionStatus, ResultPortSdCardSdCardNotSupportSwitchFunctionStatus());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultUnexpectedSdCardSwitchFunctionStatus, ResultPortSdCardUnexpectedSdCardSwitchFunctionStatus());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultSdCardNotSupportAccessMode, ResultPortSdCardSdCardNotSupportAccessMode());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultSdCardNot4BitBusWidthAtUhsIMode, ResultPortSdCardSdCardNot4BitBusWidthAtUhsIMode());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultSdCardNotSupportSdr104AndSdr50, ResultPortSdCardSdCardNotSupportSdr104AndSdr50());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultSdCardCannotSwitchedAccessMode, ResultPortSdCardSdCardCannotSwitchedAccessMode());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultSdCardFailedSwitchedAccessMode, ResultPortSdCardSdCardFailedSwitchedAccessMode());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultSdCardUnacceptableCurrentConsumption, ResultPortSdCardSdCardUnacceptableCurrentConsumption());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultSdCardNotReadyToVoltageSwitch, ResultPortSdCardSdCardNotReadyToVoltageSwitch());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultSdCardNotCompleteVoltageSwitch, ResultPortSdCardSdCardNotCompleteVoltageSwitch());

        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultInternalClockStableSwTimeout, ResultPortSdCardInternalClockStableSwTimeout());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultSdHostStandardUnknownAutoCmdError, ResultPortSdCardSdHostStandardUnknownAutoCmdError());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultSdHostStandardUnknownError, ResultPortSdCardSdHostStandardUnknownError());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultSdmmcDllCalibrationSwTimeout, ResultPortSdCardSdmmcDllCalibrationSwTimeout());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultSdmmcDllApplicationSwTimeout, ResultPortSdCardSdmmcDllApplicationSwTimeout());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultSdHostStandardFailSwitchTo18V, ResultPortSdCardSdHostStandardFailSwitchTo18V());

        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultNoWaitedInterrupt, ResultPortSdCardNoWaitedInterrupt());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultWaitInterruptSwTimeout, ResultPortSdCardWaitInterruptSwTimeout());

        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultAbortCommandIssued, ResultPortSdCardAbortCommandIssued());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultNotSupported, ResultPortSdCardNotSupported());
        NN_DETAIL_FS_RESULT_THROW_IF_INCLUDES(nn::sdmmc::ResultNotImplemented, ResultPortSdCardNotImplemented());

        NN_SDK_LOG("[fs] Warning: Unexpected Result(Module:%d, Description:%d) is detected.\n", sdmmcResult.GetModule(), sdmmcResult.GetDescription());
        // その他の Result は全て ResultSdCardAccessFailed() 内の ResultPortSdCardUnexpected() に丸める
        return ResultPortSdCardUnexpected();
    }

}   // namespace {

Result GetFsResult(nn::sdmmc::Port port, Result sdmmcResult) NN_NOEXCEPT
{
    if (sdmmcResult.IsSuccess())
    {
        NN_RESULT_SUCCESS;
    }

    if (port == nn::sdmmc::Port::Port_Mmc0)
    {
        return GetFsResultFromMmcResult(sdmmcResult);
    }
    else    // (port == nn::sdmmc::Port::Port_SdCard0)
    {
        return GetFsResultFromSdCardResult(sdmmcResult);
    }
}

}}}

