﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkLog.h>
#include <nn/sdmmc/sdmmc_Mmc.h>
#include <nn/sdmmc/sdmmc_SdCard.h>
#include <nn/sdmmc/sdmmc_DeviceVirtualAddress.h>
#include <nn/fs/fs_IStorage.h>
#include <nn/fs/fs_MemoryStorage.h>

// ダミー sdmmc
namespace nn { namespace sdmmc {

namespace {

nn::fs::IStorage* g_MemoryStorage = nullptr;

}

void SetStorage(nn::fs::IStorage* pStorage)
{
    g_MemoryStorage = pStorage;
}


void SwitchToPcvClockResetControl() NN_NOEXCEPT
{
}

void Initialize(Port port) NN_NOEXCEPT
{
    NN_UNUSED(port);
    NN_SDK_LOG("Initialized.\n");
}

void Finalize(Port port) NN_NOEXCEPT
{
    NN_UNUSED(port);
    NN_SDK_LOG("Finalize.\n");
}

void PutMmcToSleep(Port port) NN_NOEXCEPT
{
    NN_UNUSED(port);
    NN_SDK_LOG("PutToSleep.\n");
}

void AwakenMmc(Port port) NN_NOEXCEPT
{
    NN_UNUSED(port);
    NN_SDK_LOG("Awakened.\n");
}

void PutSdCardToSleep(Port port) NN_NOEXCEPT
{
    NN_UNUSED(port);
    NN_SDK_LOG("PutToSleep.\n");
}

void AwakenSdCard(Port port) NN_NOEXCEPT
{
    NN_UNUSED(port);
    NN_SDK_LOG("Awakened.\n");
}

Result GetSdCardProtectedAreaCapacity(uint32_t* pOutNumSectors, Port port) NN_NOEXCEPT
{
    NN_UNUSED(pOutNumSectors);
    NN_UNUSED(port);
    NN_SDK_LOG("GetSdCardProtectedAreaCapacity.\n");
    NN_RESULT_SUCCESS;
}

Result Activate(Port port) NN_NOEXCEPT
{
    NN_UNUSED(port);
    NN_SDK_LOG("Activated.\n");
    NN_RESULT_SUCCESS;
}

void Deactivate(Port port) NN_NOEXCEPT
{
    NN_UNUSED(port);
    NN_SDK_LOG("Deactivated.\n");
}

Result Read(void* pOutBuffer, size_t bufferSize, Port port, uint32_t sectorIndex, uint32_t numSectors) NN_NOEXCEPT
{
    NN_UNUSED(port);
    NN_ABORT_UNLESS_NOT_NULL(g_MemoryStorage);
    if( bufferSize == 0 && numSectors == 0 )
    {
        NN_RESULT_SUCCESS;
    }
    else if( pOutBuffer == nullptr )
    {
        return fs::ResultNullptrArgument();
    }
    return g_MemoryStorage->Read(sectorIndex * SectorSize, pOutBuffer, numSectors * SectorSize);
}

Result Write(Port port, uint32_t sectorIndex, uint32_t numSectors, const void* pData, size_t dataSize) NN_NOEXCEPT
{
    NN_UNUSED(port);
    NN_ABORT_UNLESS_NOT_NULL(g_MemoryStorage);
    if( dataSize == 0 && numSectors == 0 )
    {
        NN_RESULT_SUCCESS;
    }
    else if( pData == nullptr )
    {
        return fs::ResultNullptrArgument();
    }
    return g_MemoryStorage->Write(sectorIndex * SectorSize, pData, numSectors * SectorSize);
}

Result CheckConnection(SpeedMode* pOutHostSpeedMode, BusWidth* pOutHostBusWidth, Port port) NN_NOEXCEPT
{
    NN_UNUSED(pOutHostSpeedMode);
    NN_UNUSED(pOutHostBusWidth);
    NN_UNUSED(port);
    NN_RESULT_SUCCESS;
}

Result GetDeviceMemoryCapacity(uint32_t* pOutNumSectors, Port port) NN_NOEXCEPT
{
    NN_UNUSED(port);
    NN_ABORT_UNLESS_NOT_NULL(g_MemoryStorage);
    int64_t value;
    NN_RESULT_DO(g_MemoryStorage->GetSize(&value));
    NN_ABORT_UNLESS(value >= 0);
    *pOutNumSectors = static_cast<uint32_t>(value / SectorSize);
    NN_RESULT_SUCCESS;
}

Result SelectMmcPartition(Port port, MmcPartition mmcPartition) NN_NOEXCEPT
{
    NN_UNUSED(port);
    NN_UNUSED(mmcPartition);
    NN_RESULT_SUCCESS;
}

Result GetMmcBootPartitionCapacity(uint32_t* pOutNumSectors, Port port) NN_NOEXCEPT
{
    return GetDeviceMemoryCapacity(pOutNumSectors, port);
}

bool IsSdCardInserted(Port port) NN_NOEXCEPT
{
    NN_UNUSED(port);
    return g_MemoryStorage != nullptr;
}

void RegisterSdCardDetectionEventCallback(Port port, DeviceDetectionEventCallback callback, void* pParameter) NN_NOEXCEPT
{
    NN_UNUSED(port);
    NN_UNUSED(callback);
    NN_UNUSED(pParameter);
}

void UnregisterSdCardDetectionEventCallback(Port port) NN_NOEXCEPT
{
    NN_UNUSED(port);
}

bool IsSdCardRemoved(Port port) NN_NOEXCEPT
{
    NN_UNUSED(port);
    return false;
}


Result EraseMmc(Port port) NN_NOEXCEPT
{
    NN_UNUSED(port);
    NN_RESULT_SUCCESS;
}

Result GetDeviceSpeedMode(SpeedMode* pOutSpeedMode, Port port) NN_NOEXCEPT
{
    *pOutSpeedMode = (port == Port_Mmc0) ? SpeedMode_MmcHs400
                                         : SpeedMode_SdCardHighSpeed;
    NN_RESULT_SUCCESS;
}

Result GetDeviceCid(void* pOutCid, size_t cidSize, Port port) NN_NOEXCEPT
{
    NN_UNUSED(pOutCid);
    NN_UNUSED(cidSize);
    NN_UNUSED(port);
    NN_RESULT_SUCCESS;
}

void GetAndClearErrorInfo(ErrorInfo* pOutErrorInfo, size_t* pOutLogSize, char* pOutLogBuffer, size_t logBufferSize, Port port) NN_NOEXCEPT
{
    NN_UNUSED(pOutErrorInfo);
    NN_UNUSED(pOutLogSize);
    NN_UNUSED(pOutLogBuffer);
    NN_UNUSED(logBufferSize);
    NN_UNUSED(port);
}

Result GetMmcExtendedCsd(void* pOutExtendedCsdBuffer, size_t extendedCsdBufferSize, Port port) NN_NOEXCEPT
{
    NN_UNUSED(pOutExtendedCsdBuffer);
    NN_UNUSED(extendedCsdBufferSize);
    NN_UNUSED(port);
    NN_RESULT_SUCCESS;
}

void SetSdCardWorkBuffer(nn::sdmmc::Port port, void* buffer, size_t bufferSize) NN_NOEXCEPT
{
    NN_UNUSED(port);
    NN_UNUSED(buffer);
    NN_UNUSED(bufferSize);
}

void SetMmcWorkBuffer(nn::sdmmc::Port port, void* buffer, size_t bufferSize) NN_NOEXCEPT
{
    NN_UNUSED(port);
    NN_UNUSED(buffer);
    NN_UNUSED(bufferSize);
}

void RegisterDeviceVirtualAddress(Port port, uintptr_t bufferAddress, size_t bufferSize, nn::dd::DeviceVirtualAddress bufferDeviceVirtualAddress) NN_NOEXCEPT
{
    NN_UNUSED(port);
    NN_UNUSED(bufferAddress);
    NN_UNUSED(bufferSize);
    NN_UNUSED(bufferDeviceVirtualAddress);
}

void UnregisterDeviceVirtualAddress(Port port, uintptr_t bufferAddress, size_t bufferSize, nn::dd::DeviceVirtualAddress bufferDeviceVirtualAddress) NN_NOEXCEPT
{
    NN_UNUSED(port);
    NN_UNUSED(bufferAddress);
    NN_UNUSED(bufferSize);
    NN_UNUSED(bufferDeviceVirtualAddress);
}

}}
