﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <mutex>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_SdkLog.h>
#include <nn/fs/fs_Result.h>
#include <nn/result/result_HandlingUtility.h>

#include "fssrv_SdCardDetectionEventManager.h"
#include "fssrv_SdmmcStorageService.h"

namespace nn { namespace fssrv { namespace detail {

    SdCardDetectionEventManager::SdCardDetectionEventManager() NN_NOEXCEPT
    {
        RegisterSdCardDetectionEventCallback(DeviceDetectionEventCallback, &m_Param);
    }

    SdCardDetectionEventManager::~SdCardDetectionEventManager() NN_NOEXCEPT
    {
        UnregisterSdCardDetectionEventCallback();
    }

}}}
