﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_BinTypes.h>
#include <nn/fs/fs_IStorage.h>
#include <nn/fs/fs_ResultPrivate.h>
#include <nn/fs/fs_SaveDataTypes.h>

namespace nn { namespace fssrv { namespace detail {

    class SaveDataExtender
    {
        NN_DISALLOW_COPY(SaveDataExtender);

    public:
        static int64_t QueryContextSize() NN_NOEXCEPT;

        SaveDataExtender() NN_NOEXCEPT;

        nn::Result InitializeContext(
            const fssystem::save::JournalIntegritySaveDataParameters& extendedSaveDataParameters) NN_NOEXCEPT;

        nn::Result WriteContext(nn::fs::IStorage* pContextStorage) const NN_NOEXCEPT;

        nn::Result ReadContext(nn::fs::IStorage* pContextStorage) NN_NOEXCEPT;

        int64_t GetLogSize() const NN_NOEXCEPT;

        int64_t GetExtendedSaveDataSize() const NN_NOEXCEPT;

        nn::Result Extend(
            nn::fs::SubStorage saveDataStorage,
            nn::fs::SubStorage logStorage,
            nn::fssystem::IBufferManager* pBufferManager,
            nn::fssystem::IMacGenerator* pMacGenerator,
            uint32_t minimumVersion) NN_NOEXCEPT;

        int64_t GetAvailableSize() const NN_NOEXCEPT
        {
            return m_Context.availableBlockCount * m_Context.blockSize;
        }

        int64_t GetJournalSize() const NN_NOEXCEPT
        {
            return m_Context.journalBlockCount * m_Context.blockSize;
        }

    private:
        enum class State : uint32_t
        {
            None,
            Extending,
            Committing,
            Finalizing
        };

    private:
        struct Context
        {
            uint32_t signature;
            uint32_t version;
            State state;
            char _reserved[4];
            int64_t availableBlockCount;
            int64_t journalBlockCount;
            int64_t blockSize;
            int64_t extendedSaveDataSize;
        };
        NN_STATIC_ASSERT(std::is_pod<Context>::value);

    private:
        nn::fs::IStorage* m_pContextStorage;
        Context m_Context;
    };

}}}
