﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_Mutex.h>
#include <nn/util/util_IntrusiveList.h>

#include "fssrv_ProgramInfo.h"

namespace nn { namespace fssrv { namespace detail {

    class ProgramRegistryManager
    {
        NN_DISALLOW_COPY(ProgramRegistryManager);
        NN_DISALLOW_MOVE(ProgramRegistryManager);
    public:
        ProgramRegistryManager() NN_NOEXCEPT;
        ~ProgramRegistryManager() NN_NOEXCEPT;

        Result RegisterProgram(uint64_t processId, uint64_t programId, uint8_t storageId, const void* fsAccessControlData, int64_t dataSize, const void* fsAccessControlDesc, int64_t descSize) NN_NOEXCEPT;
        Result UnregisterProgram(uint64_t processId) NN_NOEXCEPT;

        Result GetProgramInfo(std::shared_ptr<ProgramInfo>* pOutValue, uint64_t processId) NN_NOEXCEPT;
        Result GetProgramInfoByProgramId(std::shared_ptr<ProgramInfo>* pOutValue, Bit64 programId) NN_NOEXCEPT;
    private:
        util::IntrusiveList<ProgramInfoNode, util::IntrusiveListBaseNodeTraits<ProgramInfoNode>> m_ProgramInfoList;
        nn::os::Mutex m_ProgramInfoListMutex;
    };
}}}
