﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <mutex>
#include <nn/nn_Abort.h>
#include <nn/fs/fs_SaveDataPrivate.h>
#include <nn/fs/detail/fs_Log.h>
#include <nn/fs/fsa/fs_IFile.h>
#include <nn/fs/fsa/fs_IDirectory.h>
#include <nn/fs/fsa/fs_IFileSystem.h>
#include <nn/fssrv/sf/fssrv_IFileSystem.h>
#include <nn/fssrv/fssrv_FileSystemProxyImpl.h>
#include <nn/fssystem/fs_AsynchronousAccess.h>
#include <nn/fssystem/fs_PathTool.h>
#include <nn/fssystem/fs_ThreadPriorityChanger.h>
#include <nn/fssystem/fs_Utility.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/fs/fs_ResultPrivate.h>
#include <nn/fs/detail/fs_ResultHandlingUtility.h>
#include <nn/sf/sf_ContextControl.h>
#include <nn/sf/sf_ObjectFactory.h>
#include <nn/sf/impl/sf_AllocationPolicies.h>
#include <nn/util/util_Optional.h>

#include "fssrv_MultiCommitManager.h"
#include "fssrv_AllocatorForServiceFrameWork.h"

#include "fssrv_Trace.h"

namespace nn { namespace fssrv { namespace detail {

MultiCommitManager::MultiCommitManager() NN_NOEXCEPT
    : m_pFileSystems()
    , m_FileSystemCount(0)
    , m_Counter(0)
{
}

// アトミックにコミットしたいセーブデータを追加
Result MultiCommitManager::Add(nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem> fileSystem) NN_NOEXCEPT
{
    NN_RESULT_THROW_UNLESS(m_FileSystemCount < static_cast<int>(NN_ARRAY_SIZE(m_pFileSystems)), nn::fs::ResultOutOfResource());

    fs::detail::IFileSystemPointer pImpl;
    NN_RESULT_DO(fileSystem->GetImpl(&pImpl));

    m_pFileSystems[m_FileSystemCount] = std::move(pImpl);
    ++m_FileSystemCount;

    NN_RESULT_SUCCESS;
}

// 複数のセーブデータをアトミックにコミット
Result MultiCommitManager::Commit() NN_NOEXCEPT
{
    NN_RESULT_DO(CommitFileSystem());
    NN_RESULT_SUCCESS;
}

// 本コミット
Result MultiCommitManager::CommitFileSystem() NN_NOEXCEPT
{
    for( int i = 0; i < m_FileSystemCount; ++i )
    {
        // TODO: コミット済みのファイルシステムに再コミットしても何も起きないようにする必要がある
        NN_SDK_ASSERT_NOT_NULL(m_pFileSystems[i]);
        NN_RESULT_DO(m_pFileSystems[i]->Commit());
    }
    NN_RESULT_SUCCESS;
}

}}}
