﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>
#include <mutex>
#include <nn/nn_Macro.h>
#include <nn/fs/fsa/fs_IFileSystem.h>
#include <nn/os/os_Mutex.h>

namespace nn { namespace fssrv { namespace detail {

    enum FatDriveId
    {
        FatDriveId_BisCalibration = 0,
        FatDriveId_BisSafeMode,
        FatDriveId_BisUser,
        FatDriveId_BisSystem,
        FatDriveId_SdCard,
        FatDriveId_BisSystemProperPartition,

        FatDriveId_Count // Externals/prfile2/config/prfile2/pf_config.h: PF_MAX_DISK, PF_MAX_VOLUME
    };

    class FatFileSystemCacheManager
    {
        NN_DISALLOW_COPY(FatFileSystemCacheManager);
        NN_DISALLOW_MOVE(FatFileSystemCacheManager);
    public:
        FatFileSystemCacheManager()
            : m_Mutex(true)
        {
            for (int i = 0; i < FatDriveId_Count; i++)
            {
                m_pFatFileSystem[i].reset();
            }
        }
        void SetCache(std::shared_ptr<nn::fs::fsa::IFileSystem>& pFileSystem, FatDriveId id)
        {
            m_pFatFileSystem[id] = pFileSystem;
        }
        void UnsetCache(FatDriveId id)
        {
            m_pFatFileSystem[id].reset();
        }
        std::shared_ptr<nn::fs::fsa::IFileSystem>& GetCache(FatDriveId id)
        {
            return m_pFatFileSystem[id];
        }
        std::unique_lock<os::Mutex> GetScopedLock()
        {
            return std::unique_lock<os::Mutex>(m_Mutex);
        }

    private:
        std::shared_ptr<nn::fs::fsa::IFileSystem> m_pFatFileSystem[FatDriveId_Count]; // FS プロセス自身が参照することで保持する
        os::Mutex m_Mutex;
    };

}}}
