﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/fs/fs_ErrorInfoPrivate.h>
#include <nn/fs/fs_GameCard.h>
#include <nn/fssrv/sf/fssrv_IDeviceOperator.h>
#include <nn/gc/detail/gc_Types.h>

namespace nn { namespace fssrv { namespace detail {

    class AccessControl;
    class DeviceOperator
    {
    public:
        DeviceOperator(const AccessControl* accessControl, Bit64 processId) NN_NOEXCEPT;
        ~DeviceOperator() NN_NOEXCEPT;

        // SD
        Result IsSdCardInserted(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
        Result GetSdCardCid(const nn::sf::OutBuffer& outBuffer, std::int64_t size) NN_NOEXCEPT;
        Result GetSdCardSpeedMode(nn::sf::Out<int64_t> outValue) NN_NOEXCEPT;
        Result GetSdCardUserAreaSize(nn::sf::Out<int64_t> outValue) NN_NOEXCEPT;
        Result GetSdCardProtectedAreaSize(nn::sf::Out<int64_t> outValue) NN_NOEXCEPT;
        Result GetAndClearSdCardErrorInfo(nn::sf::Out<nn::fs::StorageErrorInfo> outStorageErrorInfo, nn::sf::Out<std::int64_t> outLogSize, const nn::sf::OutBuffer& outLogBuffer, std::int64_t logBufferSize) NN_NOEXCEPT;

        // MMC
        Result GetMmcCid(const nn::sf::OutBuffer& outBuffer, std::int64_t size) NN_NOEXCEPT;
        Result GetMmcSpeedMode(nn::sf::Out<int64_t> outValue) NN_NOEXCEPT;
        Result EraseMmc(std::uint32_t id) NN_NOEXCEPT;
        Result GetMmcPartitionSize(nn::sf::Out<int64_t> outValue, std::uint32_t id) NN_NOEXCEPT;
        Result GetMmcPatrolCount(nn::sf::Out<uint32_t> outValue) NN_NOEXCEPT;
        Result GetAndClearMmcErrorInfo(nn::sf::Out<nn::fs::StorageErrorInfo> outStorageErrorInfo, nn::sf::Out<std::int64_t> outLogSize, const nn::sf::OutBuffer& outLogBuffer, std::int64_t logBufferSize) NN_NOEXCEPT;
        Result GetMmcExtendedCsd(const nn::sf::OutBuffer& outBuffer, std::int64_t size) NN_NOEXCEPT;
        Result SuspendMmcPatrol() NN_NOEXCEPT;
        Result ResumeMmcPatrol() NN_NOEXCEPT;

        // GC
        Result IsGameCardInserted(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
        Result EraseGameCard(std::uint32_t memorySizeId, std::uint64_t normalAreaSize) NN_NOEXCEPT;
        Result GetGameCardHandle(nn::sf::Out<uint32_t> outValue) NN_NOEXCEPT;
        Result GetGameCardUpdatePartitionInfo(nn::sf::Out<uint32_t> outVersion, nn::sf::Out<uint64_t> outId, std::uint32_t handle) NN_NOEXCEPT;
        Result FinalizeGameCardDriver() NN_NOEXCEPT;
        Result GetGameCardAttribute(nn::sf::Out<uint8_t> outValue, std::uint32_t handle) NN_NOEXCEPT;
        Result GetGameCardDeviceCertificate(const nn::sf::OutBuffer& outBuffer, std::int64_t outBufferSize, std::uint32_t handle) NN_NOEXCEPT;
        Result GetGameCardAsicInfo(const nn::sf::OutBuffer& outBuffer, std::int64_t outBufferSize, const nn::sf::InBuffer& inBuffer, std::int64_t inBufferSize) NN_NOEXCEPT;
        Result GetGameCardIdSet(const nn::sf::OutBuffer& outBuffer, std::int64_t outBufferSize) NN_NOEXCEPT;
        Result WriteToGameCardDirectly(std::int64_t offset, const nn::sf::OutBuffer& outBuffer, std::int64_t outBufferSize) NN_NOEXCEPT;
        Result SetVerifyWriteEnalbleFlag(bool flag) NN_NOEXCEPT;
        Result GetGameCardImageHash(const nn::sf::OutBuffer& outBuffer, std::int64_t outBufferSize, std::uint32_t handle) NN_NOEXCEPT;
        Result GetGameCardDeviceIdForProdCard(const nn::sf::OutBuffer& outBuffer, std::int64_t outBufferSize, const nn::sf::InBuffer& inBuffer, std::int64_t inBufferSize) NN_NOEXCEPT;
        Result EraseAndWriteParamDirectly(const nn::sf::InBuffer& inBuffer, std::int64_t inBufferSize) NN_NOEXCEPT;
        Result ReadParamDirectly(const nn::sf::OutBuffer& outBuffer, std::int64_t outBufferSize) NN_NOEXCEPT;
        Result ForceEraseGameCard() NN_NOEXCEPT;
        Result GetGameCardErrorInfo(nn::sf::Out<nn::fs::GameCardErrorInfo> outValue) NN_NOEXCEPT;
        Result GetGameCardErrorReportInfo(nn::sf::Out<nn::fs::GameCardErrorReportInfo> outValue) NN_NOEXCEPT;
        Result GetGameCardDeviceId(const nn::sf::OutBuffer& outBuffer, std::int64_t outBufferSize) NN_NOEXCEPT;

        // SpeedEmulation
        nn::Result SetSpeedEmulationMode(std::int32_t mode) NN_NOEXCEPT;
        nn::Result GetSpeedEmulationMode(nn::sf::Out<std::int32_t> outValue) NN_NOEXCEPT;

        // SdmmcControl
        Result GetSdmmcConnectionStatus(nn::sf::Out<int32_t> outSdmmcSpeedMode, nn::sf::Out<int32_t> outSdmmcBusWidth, std::int32_t sdmmcPort) NN_NOEXCEPT;
        Result SuspendSdmmcControl() NN_NOEXCEPT;
        Result ResumeSdmmcControl() NN_NOEXCEPT;

        // Device Detection / Access Error Simulation
        Result SetDeviceSimulationEvent(std::uint32_t deviceType, std::uint32_t targetOperationFlag, std::uint32_t failureEventType, std::uint32_t respondingFailureResultValue, bool isPersistent) NN_NOEXCEPT;
        Result ClearDeviceSimulationEvent(std::uint32_t deviceType) NN_NOEXCEPT;

    private:
        const AccessControl* m_AccessControl;
        const Bit64 m_ProcessId NN_IS_UNUSED_MEMBER;
    };

}}}
