﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os/os_Mutex.h>
#include <nn/fs/fs_DeviceSimulation.h>

namespace nn { namespace fssrv { namespace detail {

    class IDeviceEventSimulator
    {
    public:
        explicit IDeviceEventSimulator(uint32_t timeoutMsec) NN_NOEXCEPT;
        virtual ~IDeviceEventSimulator() NN_NOEXCEPT;

        void SetDeviceEvent(uint32_t targetOperationFlag, fs::SimulatingDeviceAccessFailureEventType eventType, Result respondingFailureResult, bool isPersistent) NN_NOEXCEPT;
        void ClearDeviceEvent() NN_NOEXCEPT;
        void SetDetectionSimulationMode(fs::SimulatingDeviceDetectionMode simulatingDetectionMode) NN_NOEXCEPT;
        void ClearDetectionSimulationMode() NN_NOEXCEPT;

        Result CheckSimulatedAccessFailureEvent(fs::SimulatingDeviceTargetOperation targetOperation) NN_NOEXCEPT;
        bool FilterDetectionState(bool originalDetectionState) NN_NOEXCEPT;

    protected:
        virtual Result GetCoresspondingResult(fs::SimulatingDeviceAccessFailureEventType eventType) NN_NOEXCEPT;
        virtual void SimulateTimeout() NN_NOEXCEPT;

    protected:
        bool m_IsAccessFailureSimulationEnabled;
        bool m_IsDeviceDetectionSimulationEnabled;
        nn::os::Mutex m_Mutex;

        fs::SimulatingDeviceDetectionMode m_DetectionMode;
        fs::SimulatingDeviceAccessFailureEventType m_FailureEvent;
        uint32_t m_TargetOperationFlag;
        Result m_RespondingFailureResult;
        bool m_IsPersistent;
        const uint32_t m_TimeoutMsec;
    };


    class GameCardEventSimulator : public IDeviceEventSimulator
    {
    public:
        GameCardEventSimulator();
        virtual ~GameCardEventSimulator() NN_NOEXCEPT;

    protected:
        virtual Result GetCoresspondingResult(fs::SimulatingDeviceAccessFailureEventType eventType) NN_NOEXCEPT;

    protected:
        static const uint32_t DefaultTimeoutMsec = 2000;
    };

    // インスタンスの取得
    GameCardEventSimulator& GetGameCardEventSimulator() NN_NOEXCEPT;
}}}
