﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>
#include <mutex>
#include <nn/nn_Common.h>
#include <nn/os/os_Mutex.h>
#include <nn/sf/impl/sf_AllocationPolicies.h>

#include <nn/fs/detail/fs_Newable.h> // TODO: fssrv 向けのアロケータを別途用意する

namespace nn { namespace fssrv { namespace detail {
    class AllocatorForServiceFrameWork
    {
    public:
        AllocatorForServiceFrameWork()
          : m_Mutex(false)
        {
        }

        typedef nn::sf::impl::StatelessAllocationPolicy<AllocatorForServiceFrameWork> Policy;

        void* Allocate(size_t size) NN_NOEXCEPT
        {
            std::lock_guard<nn::os::Mutex> scopedLock(m_Mutex);
            return nn::fs::detail::Allocate(size);
        }

        void Deallocate(void* p, size_t size) NN_NOEXCEPT
        {
            std::lock_guard<nn::os::Mutex> scopedLock(m_Mutex);
            nn::fs::detail::Deallocate(p, size);
        }
    private:
        nn::os::Mutex m_Mutex;
    };
}}}
