﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/fs/detail/fs_Newable.h>
#include <nn/fssrv/sf/fssrv_IEventNotifier.h>
#include <nn/ncm/ncm_ProgramId.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/util/util_IntrusiveList.h>
#include <nn/util/util_Optional.h>

namespace nn { namespace fssrv { namespace detail {

    class AccessFailureDetectionEventManager;
    class AccessFailureDetectionEventNotifier : public util::IntrusiveListBaseNode<AccessFailureDetectionEventNotifier>, public fs::detail::Newable
    {
    public:
        enum class State : uint8_t
        {
            None = 0,
            Signaled,
            Disabled,
        };

    public:
        AccessFailureDetectionEventNotifier(AccessFailureDetectionEventManager* pManager, Bit64 processId) NN_NOEXCEPT;
        ~AccessFailureDetectionEventNotifier() NN_NOEXCEPT;

        Result GetEventHandle(nn::sf::Out<nn::sf::NativeHandle> outValue) NN_NOEXCEPT;

        bool IsInitialized() NN_NOEXCEPT;
        os::SystemEventType* GetEvent() NN_NOEXCEPT;
        Bit64 GetProcessId() NN_NOEXCEPT;

        State GetState() NN_NOEXCEPT;
        void SetState(State state) NN_NOEXCEPT;

    private:
        util::optional<os::SystemEventType> m_SystemEvent; // GetEventHandle で初期化される
        AccessFailureDetectionEventManager* m_Manager;
        Bit64 m_ProcessId;
        State m_State;
    };

}}}
