﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ncm/ncm_ProgramId.h>
#include <nn/os/os_Mutex.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/util/util_IntrusiveList.h>

namespace nn { namespace fssrv { namespace detail {

    class AccessFailureDetectionEventNotifier;
    class AccessFailureDetectionEventManager
    {
    public:
        AccessFailureDetectionEventManager() NN_NOEXCEPT;
        ~AccessFailureDetectionEventManager() NN_NOEXCEPT;

        Result CreateNotifier(std::unique_ptr<AccessFailureDetectionEventNotifier>* outValue, Bit64 processId) NN_NOEXCEPT;

        // この関数は直接実行しないでください。 AccessFailureDetectionEventNotifier のデストラクタでのみ呼ばれる想定です。
        void DeleteNotifier(AccessFailureDetectionEventNotifier* pEventNotifier) NN_NOEXCEPT;

        bool IsAccessFailureDetectionObserved(Bit64 processId) NN_NOEXCEPT;
        void NotifyAccessFailureDetection(Bit64 processId) NN_NOEXCEPT;
        void ResetAccessFailureDetection(Bit64 processId) NN_NOEXCEPT;
        void DisableAccessFailureDetection(Bit64 processId) NN_NOEXCEPT;
        bool IsAccessFailureDetectionNotified(Bit64 processId) NN_NOEXCEPT;
        os::NativeHandle GetEvent() NN_NOEXCEPT;

    private:
        typedef util::IntrusiveList<AccessFailureDetectionEventNotifier, util::IntrusiveListBaseNodeTraits<AccessFailureDetectionEventNotifier>> AccessFailureDetectionEventNotifierList;

        AccessFailureDetectionEventNotifierList m_List;
        os::Mutex m_Mutex;
        os::SystemEvent m_SystemEvent;
    };

}}}
