﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/fs/fs_Result.h>
#include <nn/fssrv/sf/fssrv_IFileSystemProxy.h>

#include <nn/fs/fs_SystemDataUpdateEvent.h>
#include <nn/fs/fs_SystemDataUpdateEventPrivate.h>

#include "fs_EventNotifierObjectAdapter.h"
#include "fs_FileSystemProxyServiceObject.h"
#include <nn/fs/detail/fs_ResultHandlingUtility.h>

namespace nn { namespace fs {

Result OpenSystemDataUpdateEventNotifier(std::unique_ptr<IEventNotifier>* outValue) NN_NOEXCEPT
{
    nn::sf::SharedPointer<nn::fssrv::sf::IFileSystemProxy> fileSystemProxy = detail::GetFileSystemProxyServiceObject();
    nn::sf::SharedPointer<nn::fssrv::sf::IEventNotifier> eventNotifier;
    NN_FS_RESULT_DO(fileSystemProxy->OpenSystemDataUpdateEventNotifier(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IEventNotifier>>(&eventNotifier)));
    outValue->reset(new detail::EventNotifierObjectAdapter(std::move(eventNotifier)));
    NN_FS_RESULT_THROW_UNLESS(*outValue, ResultAllocationMemoryFailedNew());
    NN_RESULT_SUCCESS;
}

Result NotifySystemDataUpdateEvent() NN_NOEXCEPT
{
    nn::sf::SharedPointer<nn::fssrv::sf::IFileSystemProxy> fileSystemProxy = detail::GetFileSystemProxyServiceObject();
    NN_FS_RESULT_DO(fileSystemProxy->NotifySystemDataUpdateEvent());
    NN_RESULT_SUCCESS;
}

}}
