﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>
#include <nn/fssrv/sf/fssrv_IStorage.h>
#include <nn/fs/fs_QueryRange.h>

#include "fs_StorageServiceObjectAdapter.h"

namespace nn { namespace fs { namespace detail {
    StorageServiceObjectAdapter::StorageServiceObjectAdapter(nn::sf::SharedPointer<nn::fssrv::sf::IStorage>&& storageServiceObject) NN_NOEXCEPT
      : m_storageServiceObject(storageServiceObject)
    {
    }
    StorageServiceObjectAdapter::~StorageServiceObjectAdapter() NN_NOEXCEPT
    {
    }
    Result StorageServiceObjectAdapter::Read(int64_t offset, void* buffer, size_t size) NN_NOEXCEPT
    {
        return m_storageServiceObject->Read(offset, nn::sf::OutBuffer(reinterpret_cast<char*>(buffer), size), static_cast<int64_t>(size));
    }
    Result StorageServiceObjectAdapter::Write(int64_t offset, const void* buffer, size_t size) NN_NOEXCEPT
    {
        return m_storageServiceObject->Write(offset, nn::sf::InBuffer(reinterpret_cast<const char*>(buffer), size), static_cast<int64_t>(size));
    }
    Result StorageServiceObjectAdapter::Flush() NN_NOEXCEPT
    {
        return m_storageServiceObject->Flush();
    }
    Result StorageServiceObjectAdapter::SetSize(int64_t size) NN_NOEXCEPT
    {
        return m_storageServiceObject->SetSize(size);
    }
    Result StorageServiceObjectAdapter::GetSize(int64_t* outValue) NN_NOEXCEPT
    {
        return m_storageServiceObject->GetSize(nn::sf::Out<int64_t>(outValue));
    }
    Result StorageServiceObjectAdapter::OperateRange(
        void* outBuffer, size_t outBufferSize, OperationId operationId, int64_t offset, int64_t size, const void* inBuffer, size_t inBufferSize) NN_NOEXCEPT
    {
        NN_UNUSED(inBuffer);
        NN_UNUSED(inBufferSize);

        if( operationId == OperationId::QueryRange )
        {
            NN_RESULT_THROW_UNLESS(outBufferSize == sizeof(StorageQueryRangeInfo), ResultInvalidSize());

            return m_storageServiceObject->OperateRange(
                nn::sf::Out<StorageQueryRangeInfo>(reinterpret_cast<StorageQueryRangeInfo*>(outBuffer)),
                static_cast<int32_t>(operationId),
                offset,
                size);
        }

        NN_RESULT_THROW(nn::fs::ResultUnsupportedOperation());
    }
}}}
