﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkAssert.h>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/fs/fs_Result.h>
#include <nn/fs/fs_Directory.h>
#include <nn/fs/fs_SaveDataPrivate.h>
#include <nn/fs/fs_PathUtility.h>

#include <nn/fs/fs_SaveDataForDebug.h>

#include "fs_FileSystemProxyServiceObject.h"
#include <nn/fs/detail/fs_AccessLog.h>
#include <nn/fs/detail/fs_ResultHandlingUtility.h>

namespace nn { namespace fs {

void SetSaveDataRootPath(const char* rootPath) NN_NOEXCEPT
{
    auto SetSaveDataRootPathImpl = [=]() NN_NOEXCEPT -> Result
    {
        NN_RESULT_THROW_UNLESS(strnlen(rootPath, EntryNameLengthMax + 1) <= EntryNameLengthMax, ResultTooLongPath());
        nn::sf::SharedPointer<nn::fssrv::sf::IFileSystemProxy> fileSystemProxy = detail::GetFileSystemProxyServiceObject();
        nn::fssrv::sf::FspPath sfPath;
        NN_RESULT_DO(FspPathPrintf(&sfPath, "%s", rootPath));

        NN_RESULT_DO(fileSystemProxy->SetSaveDataRootPath(sfPath));
        NN_RESULT_SUCCESS;
    };
    NN_FS_ABORT_UNLESS_RESULT_SUCCESS(NN_DETAIL_FS_ACCESS_LOG(SetSaveDataRootPathImpl(), nullptr, NN_DETAIL_FS_ACCESS_LOG_FORMAT_PATH, rootPath));
}

Result MountSaveDataForDebug(const char* name) NN_NOEXCEPT
{
    return MountSaveData(name, InvalidUserId);
}

}}

